#include <stdlib.h>
#include <string>
#include "Common.h"

namespace AScript {
	
const char *EncodingFromLANG()
{
	const char *encodingDefault = "us-ascii";
	struct AssocInfo {
		const char *key;
		const char *value;
	};
	const char *str = ::getenv("LANG");
	if (str == NULL) return encodingDefault;
	const char *p = ::strchr(str, '.');
	String langLeft, langRight;
	if (p == NULL) {
		langLeft = str;
	} else {
		langLeft = String(str, p - str);
		langRight = p + 1;
	}
	if (langRight.empty()) {
		static const AssocInfo assocInfoTbl[] = {
			{ "C",		"us-ascii" },
			{ "en_US",	"us-ascii" },
			{ "ja",	 	"euc-jp" },
			{ "ja_JP",	"euc-jp" },
		};
		for (int i = 0; i < NUMBEROF(assocInfoTbl); i++) {
			if (langLeft.compare(assocInfoTbl[i].key) == 0) {
				return assocInfoTbl[i].value;
			}
		}
	} else {
		static const AssocInfo assocInfoTbl[] = {
			{ "eucJP",	"euc-jp" },
			{ "ujis",	"euc-jp" },
			{ "UTF-8",	"utf-8" },
			{ "SJIS",	"shift_jis" },
		};
		for (int i = 0; i < NUMBEROF(assocInfoTbl); i++) {
			if (langRight.compare(assocInfoTbl[i].key) == 0) {
				return assocInfoTbl[i].value;
			}
		}
	}
	return encodingDefault;
}

}

main()
{
	::printf("%s\n", AScript::EncodingFromLANG());
}
