//-----------------------------------------------------------------------------
// AScript magick module
//-----------------------------------------------------------------------------
#include <ascript.h>

AScript_BeginModule(magick)

AScript_DeclarePrivSymbol(hoge_symbol);

//-----------------------------------------------------------------------------
// AScript module functions: magick
//-----------------------------------------------------------------------------
// magick.skeleton()
AScript_DeclareFunction(skeleton)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
}

AScript_ImplementFunction(skeleton)
{
	return Value::Null;
}

// result = magick.adder(num1:number, num2:number)
AScript_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, FLAG_None);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder)
{
	return Value(args.GetNumber(0) + args.GetNumber(1));
}

// result = magick.adder2(num1:number, num2:number):map
// automapping version of adder(). see differences in their implementations.
AScript_DeclareFunction(adder2)
{
	SetMode(RSLTMODE_Normal, FLAG_Map);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder2)
{
	return Value(args.GetNumber(0) + args.GetNumber(1));
}

// Module entry
AScript_ModuleEntry()
{
	// symbol realization
	AScript_RealizePrivSymbol(hoge_symbol);
	// value assignment
	AScript_AssignValue(foo, Value(env, "a value in magick module"));
	// function assignment
	AScript_AssignFunction(skeleton);
	AScript_AssignFunction(adder);
	AScript_AssignFunction(adder2);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(magick, magick)

AScript_RegisterModule(magick)
