//---------------------------------------------------------------------------
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
//unit02.jsはページに関する処理
//---------------------------------------------------------------------------
function ViewPage()
//ページを切り替える
{
	var		aPage;

	aPage = CheckPage();
	if(aPage == null) {
		alert('表示するページを選択してください');
		return;
	}

	$('iListPage').submit();		//formを送ることでページを全面改定する
}
//---------------------------------------------------------------------------
function NewPage()
//ページを作成
{
	var		aNewPage;

	if(kDemo) return;	//デモならば返る
	aNewPage = prompt('ページ名を入力してください','');
	if(aNewPage == null) return;

	SendPageCmd('NewPage',aNewPage,'dummy');
}
//---------------------------------------------------------------------------
function RenPage()
//ページの名前を変更する
{
	var		aNewPage,aOldPage;

	if(kDemo) return;	//デモならば返る
	aOldPage = CheckPage();
	if(aOldPage == null) {
		alert('名前を変えるページを選択してください');
		return;
	}

	aNewPage = prompt('新しい名前を入力してください','');
	if(aNewPage == null) return;

	SendPageCmd('RenPage',aNewPage,aOldPage);
}
//---------------------------------------------------------------------------
function DelPage()
//ページを削除
{
	var		aDelPage,ret;

	if(kDemo) return;	//デモならば返る
	aDelPage = CheckPage();
	if(aDelPage == null) {
		alert('削除するページを選択してください');
		return;
	}

	ret = confirm('削除してもよろしいですか？\n削除したものを復活させることはできません。');
	if(ret) {
		SendPageCmd('DelPage','dummy',aDelPage);
	}
}
//---------------------------------------------------------------------------
function ListPage()
//ページ一覧を表示する
{
	SendPageCmd('ListPage','dummy','dummy');
	ShowObject('iInfo');
}
//---------------------------------------------------------------------------
function CheckPage()
//ページ操作で選択されているかどうか調べる
//戻り値	選択されているページの名前 無い場合は  null
{
	var		r,i;

	r = document.getElementsByName('nPage');
	for(i=0;i<r.length;i++) {
		if(r[i].checked) break;
	}
	if(i == r.length) {
		return(null);
	}
	return(r[i].value);
}
//---------------------------------------------------------------------------
function SendPageCmd(pCmd,pNewPage,pOldPage)
//ページのデータを送信する
//引数		pCmd     :コマンド
//			pNewPage :操作するページの名前
//			pOldPage :操作するページの名前
{
	var		param,aAjax;

	if(kDebug) ShowObject('iInfo');

	param = 'nCmd=' + pCmd + '&nNewPage=' + encodeURIComponent(pNewPage) + '&nOldPage=' + encodeURIComponent(pOldPage);
	aAjax = new Ajax.Updater('iInfoText',gCGIProgram,{method: 'post',parameters: param,onFailure: ErrorAlert});
}
//---------------------------------------------------------------------------
