<?php
//---------------------------------------------------------------------------
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
//unit01.incは付箋に関する処理
//---------------------------------------------------------------------------
function NewLabel()
//付箋を作る
//使用する変数	$gBaseDir       : データのあるディレクトリ(プログラムファイルから見た相対パス)
//				$gPage          : ページのディレクトリ
//				$_POST['nID']   : 付箋のID
//				$_POST['nAtt']  : 属性
//				$_POST['nText'] : 内容
{
	global	$gPage,$gBaseDir;

	$name = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.att';
	$fp = fopen($name,"w");		//属性
	fputs($fp,$_POST['nAtt']);
	fflush($fp);
	fclose($fp);
//	chmod($name,0666);

	$name = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.txt';
	$fp  = fopen($name,"w");	//本体

	$str = $_POST['nText'];
	if(get_magic_quotes_gpc()) $str = stripslashes($str);	//Fedora 5の標準はOFFらしい

	fputs($fp,$str);
	fflush($fp);
	fclose($fp);
//	chmod($name,0666);
	echo '新規付箋 ' . $_POST['nID'];
}
//---------------------------------------------------------------------------
function DelLabel()
//付箋を削除
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_POST['nID']  : 付箋のID
{
	global	$gPage,$gBaseDir;

	$name = $gBaseDir . $gPage . '/' . $_POST['nID'];

	if(is_writable($name . '.att')) {
		unlink($name . '.att');
		unlink($name . '.txt');
		echo '付箋削除 ' . $_POST['nID'];
	} else {
		echo '編集制限 ' . $_POST['nID'];
	}
}
//---------------------------------------------------------------------------
function ModLabel()
//付箋を変更
{
	NewLabel();
}
//---------------------------------------------------------------------------
function AttLabel()
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_POST['nID']  : 付箋のID
//				$_POST['nAtt'] : 属性
{
	global	$gPage,$gBaseDir;

	$name = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.att';
	$fp = fopen($name,"w");		//属性
	fputs($fp,$_POST['nAtt']);
	fflush($fp);
	fclose($fp);
	echo '属性変更 ' . $_POST['nID'];
}
//---------------------------------------------------------------------------
function AttLabelE()
//データファイルの書き込み可能パーミッションを変更する
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_POST['nID']  : 付箋のID
//				$_POST['nAtt'] : 属性
//				$_POST['flag'] : 編集制限フラグ 1:編集可能にする
{
	global	$gPage,$gBaseDir;

	$aAtt = explode(",",$_POST['nAtt']);
	$flag = $aAtt[kEditable];

	$nameA = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.att';
	$nameT = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.txt';

	if($flag == '1') {					//現在編集不可なので編集可能にする
		chmod($nameA,0666);
		chmod($nameT,0666);
		$fp = fopen($nameA,"w");		//属性
		fputs($fp,$_POST['nAtt']);
		fflush($fp);
		fclose($fp);
		echo '編集制限解除 ' . $_POST['nID'];
	} else {
		$fp = fopen($nameA,"w");		//属性
		fputs($fp,$_POST['nAtt']);
		fflush($fp);
		fclose($fp);
		chmod($nameA,0444);
		chmod($nameT,0444);
		echo '編集制限設定 ' . $_POST['nID'];
	}
}
//---------------------------------------------------------------------------
function SendCont()
//付箋の内容を送信
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_POST['nID']  : 付箋のID
{
	global	$gPage,$gBaseDir;

	$name = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.txt';
	readfile($name);
}
//---------------------------------------------------------------------------
function SendLastMod()
//最終更新日を返す
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_POST['nID']  : 付箋のID
{
	global	$gPage,$gBaseDir;

	$filename = $gBaseDir . $gPage . '/' . $_POST['nID'] . '.txt';
	echo "最終更新日：" . date ("Y/m/d H:i", filemtime($filename));
}
//---------------------------------------------------------------------------
function SendLabel()
//付箋の内容をHTML形式を整えて出力する
//使用する変数	$gBaseDir      : データのあるディレクトリ
//				$gPage         : ページのディレクトリ
//				$_GET['nID']  : 付箋のID
{
	global	$gPage,$gBaseDir;

	$filename = $gBaseDir . $gPage . '/' . $_GET['nID'] . '.txt';
	readfile('php/unit13.inc');				//ヘッダの定形部分を出力
	readfile($filename);
	printf("\n<hr class=\"cSeparate\" />\n<div class=\"cLast\">最終更新日：" . date ("Y/m/d H:i", filemtime($filename)) . "</div>\n");
	readfile('php/unit14.inc');
}
//---------------------------------------------------------------------------
?>
