<?php
//---------------------------------------------------------------------------
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
//unit02.incはページに関する処理
//---------------------------------------------------------------------------
function ViewPage()
//ページの中にある付箋データをクライアントに送る
//使用する変数	$gBaseDir     : データのあるディレクトリ
//				$gPage        : ページのディレクトリ
{
	global	$gTitle,$gPage,$gPageName,$gBaseDir,$gAppName;

	if(! file_exists($gBaseDir . $gPage)) {
		PageNotFound();		//ページが見つからなかったというメッセージを出す
		return;
	}

	$LabelArray = GetLabelList();			//付箋配列を作る

	readfile('php/unit10.inc');				//ヘッダの定形部分を出力
	printf("<title>$gTitle</title>\n");
	printf("</head>\n<body>\n\n");
	printf("<h1 class=\"cHeaderTitle\"> $gTitle ：： $gPageName </h1>\n");
	readfile('php/unit11.inc');				//bodyの定形部分を出力

//付箋の属性の出力
	printf("<!-- 付箋の情報 -->\n");
	printf("<form class=\"cHiddenObject\" action=\"$gAppName\">\n");
	foreach($LabelArray as $key => $val) {
		printf("<input type=\"hidden\" name=\"nLabelList\" value=\"");
		readfile($val->mAttFile);
		printf("\" />\n");
	}
	printf("</form>\n\n");

//付箋データの出力
	printf("<!-- 付箋データ(読み込み時) -->\n");
	foreach($LabelArray as $key => $val) {
		printf("<div id=\"" . $val->mID . ".txt\" class=\"cInitialData\">");	//$val->mID . ".txt\"の部分を$val->mTxtFileにしてはいけない $val->mTxtFileにはディレクトリ名がある
		readfile($val->mTxtFile);
		printf("</div>\n\n");
	}
	readfile('php/unit12.inc');				//終わりの定形部分を出力
}
//---------------------------------------------------------------------------
function PageNotFound()
//ページが見つからなかったというメッセージを出す
{
	global	$gTitle,$gPage;

	readfile('php/unit10.inc');				//ヘッダの定形部分を出力
	printf("<title>$gTitle</title>\n");
	printf("</head>\n<body>\n\n");
	printf("<h1 class=\"cHeaderTitle\"> $gTitle ：： $gPageName は見つかりませんでした </h1>\n");
	readfile('php/unit11.inc');				//bodyの定形部分を出力
	readfile('php/unit12.inc');				//終わりの定形部分を出力
}
//---------------------------------------------------------------------------
function GetLabelList()
//付箋配列を作る
//使用する変数	$gBaseDir     : データのあるディレクトリ
//				$gPage        : ページのディレクトリ
//戻り値	付箋クラスファイル
{
	global	$gPage,$gBaseDir;

	$aDir = $gBaseDir . $gPage;
	$a = array();

	$MaxZIndex = 0;
	$d = dir($aDir);
	while(false !== ($file = $d->read())) {
		$path = $aDir . '/' . $file;
		if(is_file($path)) {
			if(strstr($path,'.att')) {			//「拡張子」が.attのファイルが属性ファイル
				$f = new ULabel($aDir,$file);	//付箋データを整える
				array_push($a,$f);
				if($MaxZIndex < $f->mAtt[kZIndex]) $MaxZIndex = $f->mAtt[kZIndex];
			}
		}
	}
	$d->close();

	if(count($a) < $MaxZIndex - 200) SortAndReIndexLabel($a);	//Zオーダーがあまりにもあいている場合は調整する
	return($a);
}
//---------------------------------------------------------------------------
function SortAndReIndexLabel(&$pList)
//付箋データのソートとＺオーダーの再配置を行う
//引数		&$pList:付箋リスト配列 -- 参照渡し
{
	$c = count($pList);
	if($c == 0) return;

	for($i=0;$i<$c;$i++) {							//ソート
		for($j=$i;$j<$c;$j++) {
			if($pList[$i]->mAtt[kZIndex] > $pList[$j]->mAtt[kZIndex]) {
				$w         = $pList[$i];
				$pList[$i] = $pList[$j];
				$pList[$j] = $w;
			}
		}
	}

	for($i=0;$i<$c;$i++) {						//変更を書き込む
		$pList[$i]->mAtt[kZIndex] = 100 + $i;	//Zオーダーの調整
		$data                     = join(",",$pList[$i]->mAtt);
		$fp = fopen($pList[$i]->mAttFile,"w");
		fputs($fp,$data);
		fclose($fp);
	}
}
//---------------------------------------------------------------------------
function NewPage()
//ページを作成　作るディレクトリは pagesの下で１階層のみ
//使用する変数		$_POST['nNewPage'] : ディレクトリの名前
{
	global	$gBaseDir;

	$aDir = $gBaseDir . urlencode($_POST['nNewPage']);
	mkdir($aDir);
	chmod($aDir,0777);	//これけっこう大事

	ListPage();
}
//---------------------------------------------------------------------------
function RenPage()
//ページの名前を変更
//使用する変数	$_POST['nNewPage'] : 新しいディレクトリの名前
//				$_POST['nOldPage'] : 古いディレクトリの名前
{
	global	$gBaseDir;

	$NEW = $gBaseDir . urlencode($_POST['nNewPage']);
	$OLD = $gBaseDir . urlencode($_POST['nOldPage']);
	rename($OLD,$NEW);

	ListPage();
}
//---------------------------------------------------------------------------
function DelPage()
//指定されたページを消す
//使用する変数		$_POST['nOldPage'] : ディレクトリの名前
{
	global	$gBaseDir;

	$aDir = $gBaseDir . urlencode($_POST['nOldPage']);

	$d = dir($aDir);
	while(false !== ($file = $d->read())) {	//全てのファイルを消す
		$path = $aDir . '/' . $file;
		if(is_file($path)) {
			unlink($path);
		}
	}
	$d->close();

	rmdir($aDir);

	ListPage();
}
//---------------------------------------------------------------------------
function ListPage()
//ページ操作のダイアローグを出す
{
	global	$gBaseDir,$gAppName;
print <<< ListPageA
<form  id="iListPage" action="$gAppName" method="post">
<input id="iCmd"      type="hidden"      name="nCmd" value="ViewPage">
<table summary="ページの一覧と操作">
<tr><td style="text-align:center">ページ名</td><td style="text-align:center">最終更新日</td></tr>
ListPageA;
	$d = dir($gBaseDir);
	while(false !== ($file = $d->read())) {
		if($file == '.' || $file == '..') continue;
		$path = $gBaseDir . $file;
		if(is_dir($path)) {
			$st    = stat($path);
			$mtime = date("Y/m/d (D) H:i:s",$st['mtime']);
			$str   = urldecode($file);
			printf("<tr><td><input type=\"radio\" name=\"nPage\" value=\"%s\"/>%s</td><td>%s</td></tr>\n",$str,$str,$mtime);
		}
	}
	$d->close();
print <<< ListPageB
<tr><td colspan="2"><span class="cGeneralMenu" onclick="ViewPage()">表示</span>　<span class="cGeneralMenu" onclick="NewPage()">ページを作成</span>　<span class="cGeneralMenu" onclick="RenPage()">名前変更</span>　<span class="cGeneralMenu" onclick="DelPage()">削除</span></td></tr>
</table>
</form>
ListPageB;
}
//---------------------------------------------------------------------------
?>
