/*
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/


// This is to be used instead of system call "cls"
// (except for the first one)
// inside my terminal applications for Windows.

#include <windows.h>

//int clear() {
void clear() {
    COORD topLeft  = { 0, 0 };
    HANDLE console = GetStdHandle(STD_OUTPUT_HANDLE);
    CONSOLE_SCREEN_BUFFER_INFO screen;
    DWORD written;

    GetConsoleScreenBufferInfo(console, &screen);
    FillConsoleOutputCharacterA(
        console, ' ', screen.dwSize.X * screen.dwSize.Y, topLeft, &written
    );
    FillConsoleOutputAttribute(
        console, FOREGROUND_GREEN | FOREGROUND_RED | FOREGROUND_BLUE,
        screen.dwSize.X * screen.dwSize.Y, topLeft, &written
    );
    SetConsoleCursorPosition(console, topLeft);

	 //return 0;
}


void cursorHome( void )
{
   HANDLE console=GetStdHandle(STD_OUTPUT_HANDLE);
	COORD topleft={0,0}; //x=col, y=line

	SetConsoleCursorPosition(console, topleft);

}




void cursorRC( int r, int c )
{
   HANDLE console=GetStdHandle(STD_OUTPUT_HANDLE);
	COORD newpos={c,r}; //1stParm=col, 2ndParm=line

	SetConsoleCursorPosition(console, newpos);

}



