
separate( asudx )

-- Key-digit-Ramify
procedure kram( 
	c0: in coords;
	bad: out s9;
	--0..9: 0=>NoContradictions, 1..9=>digit leads to contradictions

	badsell: out badcelltype; --list of empty cells
	numbad: out s9 -- number of empty cells

	;
	forceoutput: in boolean := false

	) is --KeyCell Ramifications

--returns list of empty cells found
function blankFound return boolean is
	empty, found: boolean:= false;
begin

	for row in 1..9 loop
	for col in 1..9 loop --test each cell

		empty:=true;
		for dig in 1..9 loop --test each digit
		if candidate(row,col)(dig) then
			empty := false;
		end if;
		end loop; --dig
		if empty then
			found:=true;
			numbad:=numbad+1;
			badsell(numbad)(1):=row;
			badsell(numbad)(2):=col;
		end if;

	end loop; --col
	end loop; --row

	return found;

end blankFound;


procedure try( dig: in i9; bad: out s9 ) is
	changed: boolean;
begin --try

	numbad:=0;
	badsell:=(others=>(others=>0));

	loop
		flush; --addendum 30jul23
		findUnique(changed);
		exit when blankfound;
		exit when not changed;
	end loop;
	if numbad>0 then
		bad:=dig;
	else
		bad:=0;
	end if;

end try;

	k: integer := 0;
	dig: array(i9) of i9;
	dd: i9;
	ok: boolean;
	k9: m9type;

begin --kram

	for d in 1..9 loop --count candidates
		if candidate( c0(1), c0(2) )(d) then 
			k:=k+1;
			dig(k):=d;
		end if;
	end loop;



	pr:=c0(1);
	pc:=c0(2); --pick cell for highlighting

	fullsavepuzzle(true); 
	--save to disk the candidate array
	--which is temporarily overwritten.

	k9:=m9;

	bad:=0;
	for d in 1..k loop
	if bad=0 then

		ok:=fullreadpuzzle(true); --restore candidate array, & m9

		dd:=dig(d);

		for i in 1..9 loop
			candidate( c0(1), c0(2) )(i):=false;
		end loop;
		candidate( c0(1), c0(2) )(dd) := true;

		set_unbounded_string(consoleBuf, "");

		hiliteKdel:=(others=>(others=>(others=>false))); --track deleted

		m9( c0(1), c0(2) ) := dd;

		append(consoleBuf," KeyCell test:"&crlf);
		append(consoleBuf," +");
		append(consoleBuf,i2st(dd));
		append(consoleBuf,"@(");
		append(consoleBuf,i2st(c0(1)));
		append(consoleBuf,",");
		append(consoleBuf,i2st(c0(2)));
		append(consoleBuf,"):");


		flushDups( c0(1), c0(2) ); --assert dig(d) is ON

		try(dd, bad); --see if contradictory

		if bad=0 then --no contradiction; no output:
			--new_line;
			--put("=========== No Problems Found Above... ===============");
			--new_line;
			--new_line;
			null;
			if forceoutput and d=k then
				put(consoleBuf); --delayed write
			end if;
		else -- contradiction found
			put(consoleBuf); --delayed write
			new_line;
			put("Found ");
			put( i2st(numbad) );
			put(" Empty Cells @:");
			for i in 1..numbad loop
				put( " (" & i2st( badsell(i)(1) ) );
				put( "," & i2st( badsell(i)(2) ) );
				put( ")" );
			end loop;
			new_line;

			if k9(c0(1),c0(2))=bad then
				put_line(" Contradiction Reached!");
			else
				put( " Digit "& i2st(bad) & " @(" );
					put( i2st( c0(1) ) );
					put( "," & i2st( c0(2) ) );
				put( ") may be removed.");
				new_line;
			end if;

		end if;

	end if; --bad=0
	end loop; --d


	blu9:=m9; --retains m9 contents after exit of kram

	ok:=fullreadpuzzle(true); --restore from disk: candiate array


end kram;

