
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

procedure nakedQuads( rcd: cellseq; 
	t1,t2,t3,t4: out coorng; 
	found: out boolean) is


type tracetype is array(coorng) of s9; --coorng;
 

 



-- find 4 cells containing only f or s or t
function f4( f,s,t,r: coorng; trace: out tracetype ) return integer is
	kount: integer := 0;
	nootherdigits, okf, oks, okt, okr, yesf,yess,yest,yesr: boolean := false;
	row,col: integer;
	debug: boolean := false;
begin

	trace:=(others=>0);

	for c in coorng loop -- traverse the cells in this house
	row:=rcd(c)(1);
	col:=rcd(c)(2);
	if m9(row,col)=0 then --proceed, not a single

		nootherdigits:=true;
		for d in 1..9 loop
			if d/=f and d/=s and d/=t and d/=r then
				if candidate(row,col)(d) then
					nootherdigits:=false;
				end if;
			end if;
		end loop; --d

		if nootherdigits then --proceed, this cell is clean

			yesf:=false; yess:=false; yest:=false; yesr:=false;
			if candidate( rcd(c)(1), rcd(c)(2) )(f) then yesf:=true; end if;
			if candidate( rcd(c)(1), rcd(c)(2) )(s) then yess:=true; end if;
			if candidate( rcd(c)(1), rcd(c)(2) )(t) then yest:=true; end if;
			if candidate( rcd(c)(1), rcd(c)(2) )(r) then yesr:=true; end if;


			if yesf or yess or yest or yesr then

				kount:=kount+1;
				trace(kount):=c; -- #cell in sequence

				if yesf then okf:=true; end if;
				if yess then oks:=true; end if;
				if yest then okt:=true; end if;
				if yesr then okr:=true; end if;

			end if;

		end if; --nootherdigits

	end if; --not single
	end loop; --c

	if okf and oks and okt and okr then
		return kount;
	else
		return 0;
	end if;

end f4;








	type used is array(coorng) of boolean;
	digUsed: used := (others=>false);


	trace: tracetype;

begin --findQuads

	found:=false; t1:=1; t2:=1; t3:=1; t4:=1;

	for dig1 in coorng range 1..9 loop
	if not found then --outer

		for dig2 in coorng range dig1+1..9 loop
		if not found then --middle

			for dig3 in coorng range dig2+1..9 loop
			if not found then --core

				for dig4 in coorng range dig3+1..9 loop
				if not found then

					if 4=f4(dig1,dig2,dig3,dig4,trace) then --found a naked quad
						found:=true;
						t1:=trace(1); t2:=trace(2); --cells involved
						t3:=trace(3); t4:=trace(4);
					end if;

				end if; --not found
				end loop; --dig4

			end if; --core
			end loop; --dig3

		end if; --middle
		end loop; --dig2

	end if; --outer
	end loop; --dig1



end nakedQuads;

