
separate( asud )


--set colorL2 array alternating (1=>redig,2=>Green)...
--by following all linked pairs
--procedure LinkedPairs( d: in s9 ) is
procedure LinkedPairs is


used: array(s9,s9) of boolean;

	--recursive proc to search 3 houses for pals:
	procedure findPals(nchn: in integer; row,col: in i9; dig: in s9; odd: in boolean) is
		br,bc,nr,nc: integer;
		ocellrow, ocellcol: s9;
		boxnum, ocellnum, xcellnum : i9;
		nodd: boolean := not odd;
	begin

		--rowpals
		for c in 1..9 loop -- look @ 8others in same row
		if c/=col then
			if 
				( hiliteRow(row,c)(dig) or hiliteCol(row,c)(dig) )
				and rowPair(dig,row,col)=c -- in this row column pairs are col,c
				and colorL2(dig,nchains(dig),row,c)=0 
			then --newpal
				if odd then 
					colorL2(dig,nchains(dig),row,c):=1;
					append(digBuf(dig,nchn), 
						" red 1 "&i2st(dig)&"@"&i2st(row)&i2st(c));
				else 
					colorL2(dig,nchains(dig),row,c):=2; 
					append(digBuf(dig,nchn), 
						" blu 2 "&i2st(dig)&"@"&i2st(row)&i2st(c)&crlf);
				end if;
				used(row,c):=true;

				findPals(nchn,row,c,dig,nodd);
			end if;
		end if;
		end loop; --c


		--colpals
		for r in 1..9 loop -- look @ 8 others in same col
		if r/=row then
			if 
				( hiliteRow(r,col)(dig) or hiliteCol(r,col)(dig) )
				and colPair(dig,col,row)=r --in this col, row pairs are row,r
				and colorL2(dig,nchains(dig),r,col)=0 
			then --newpal
				if odd then 
					colorL2(dig,nchains(dig),r,col):=1;
					append(digBuf(dig,nchn), 
" red 1 "&i2st(dig)&"@"&i2st(r)&i2st(col));
				else 
					colorL2(dig,nchains(dig),r,col):=2; 
					append(digBuf(dig,nchn), 
" blu 2 "&i2st(dig)&"@"&i2st(r)&i2st(col)&crlf);
				end if;
				used(r,col):=true;

				findPals(nchn,r,col,dig,nodd);
			end if;
		end if;
		end loop; --c


		--boxpals
		br:= (row-1)/3; --0..2
		bc:= (col-1)/3; --0..2
		boxnum:=br*3+bc+1; --1..9

		ocellrow:=(row-1)-br*3; --0..2		(4-1)-1*3=0
		ocellcol:=(col-1)-bc*3; --0..2		(2-1)-0*3=1
		ocellnum:=ocellrow*3+ocellcol+1;--	0*3+1+1=2

		for r in 0..2 loop
		for c in 0..2 loop -- look @ 8 box-neighbors
		nr:=br*3+r+1;
		nc:=bc*3+c+1; --(nr,nc) = cellpos within this box
		xcellnum:=r*3+c+1;
		if nr/=row or nc/=col then
			if 
				hiliteBP(nr,nc)(dig) 
				and BoxPair(dig,boxnum,ocellnum)=xcellnum --ocellnum/xcellnum are pairs
				and colorL2(dig,nchains(dig),nr,nc)=0 
			then --newpal
				if odd then 
					colorL2(dig,nchains(dig),nr,nc):=1;
					append(digBuf(dig,nchn), 
" red 1 "&i2st(dig)&"@"&i2st(nr)&i2st(nc));
				else 
					colorL2(dig,nchains(dig),nr,nc):=2; 
					append(digBuf(dig,nchn), 
" blu 2 "&i2st(dig)&"@"&i2st(nr)&i2st(nc)&crlf);
				end if;
				used(nr,nc):=true;

				findPals(nchn,nr,nc,dig,nodd);
			end if;	
		end if;
		end loop; --c
		end loop; --r


	end findPals;



	odd: constant boolean := true;
	nodd: constant boolean := not odd;
	nch: integer;

begin --LinkedPairs

-- note: independent chains drawn separately to avoid confusion

	none := (others=>true);
	colorL2 := (others=>(others=>(others=>(others=>0))));
	nchains := (others=>0);

	for d in i9 loop

		used:=(others=>(others=>false)); --track cells used in chains
		--prevents recreating a chain from a different starting cell

		--nchains:=0; --track number of independent chains
		for r in 1..9 loop
		for c in 1..9 loop
			if	hiliteRow(r,c)(d) or hiliteCol(r,c)(d) or hiliteBP(r,c)(d) then 
			--one of a pair (row/col/box)

				if not used(r,c) and  colorL2(d,nchains(d),r,c)=0 then 
				--new, free to choose

				nch := nchains(d);
				set_unbounded_string(digBuf(d,nch),"");


					if odd then
						colorL2(d,nchains(d),r,c):=1;
						append(digBuf(d,nch),
							" red 1 "&i2st(d)&"@"&i2st(r)&i2st(c));
					else
						colorL2(d,nchains(d),r,c):=2;
						append(digBuf(d,nch),
							" blu 2 "&i2st(d)&"@"&i2st(r)&i2st(c)&crlf);
					end if;
					none(d):=false;
					used(r,c):=true;

					findPals(nch,r,c,d,nodd); --recursive

					nchains(d):=nchains(d)+1; -- zero-based
					if nchains(d)>s99mx then
						put_line(" error LinkedPairs: nchains too big");
						raise program_error;
					else
						null;
					end if;

				end if; --not used

			end if;
		end loop;
		end loop;

	end loop; --d

end LinkedPairs;






