
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

-- returns cell coords of 1st Xwing quad
procedure Xwing(
	r1,c1, r2,c2, r3,c3, r4,c4, dig: out s9;
	cdelete: out cellseq; cdn: out integer;
	found: out boolean) is

	victory : boolean := false;

	row,col, row2, col2: integer;

begin --Xwing (finds 1st only)

	found:=false;
	dig:=0;
	r1:=0; c1:=0;
	r2:=0; c2:=0;
	r3:=0; c3:=0;
	r4:=0; c4:=0;

	for idig in 1..9 loop
	for row1 in 1..9 loop
	for row2 in row1+1..9 loop
	for col1 in 1..9 loop
	col2:=rowPair(idig,row1,col1);
	if not found then
		if col2>0 and col2 = rowPair(idig,row2,col1) then
			r1:=row1; c1:=col1;
			r2:=row1; c2:=col2;
			r3:=row2; c3:=col1;
			r4:=row2; c4:=col2;
			dig:=idig;
			found:=true;
		end if;
	end if;
	end loop; --c1
	end loop; --r2
	end loop; --r1
	end loop; --idig


	for idig in 1..9 loop
	for col1 in 1..9 loop
	for col2 in col1+1..9 loop
	for row1 in 1..9 loop
	row2:=colPair(idig,col1,row1);
	if not found then
		if row2>0 and row2 = colPair(idig,col2,row1) then
			r1:=row1; c1:=col1;
			r2:=row1; c2:=col2;
			r3:=row2; c3:=col1;
			r4:=row2; c4:=col2;
			dig:=idig;
			found:=true;
		end if;
	end if;
	end loop; --r1
	end loop; --c2
	end loop; --c1
	end loop; --idig


	cdn:=0;
	if found then --search aligned cells for dig

		row:=r1;
		for col in 1..9 loop
			if col/=c1 and col/=c2 and candidate(row,col)(dig) then
				cdn:=cdn+1;
				cdelete(cdn):=(row,col);
			end if;
		end loop;

		row:=r3;
		for col in 1..9 loop
			if col/=c1 and col/=c2 and candidate(row,col)(dig) then
				cdn:=cdn+1;
				cdelete(cdn):=(row,col);
			end if;
		end loop;


		col:=c1;
		for row in 1..9 loop
			if row/=r1 and row/=r3 and candidate(row,col)(dig) then
				cdn:=cdn+1;
				cdelete(cdn):=(row,col);
			end if;
		end loop;

		col:=c2;
		for row in 1..9 loop
			if row/=r1 and row/=r3 and candidate(row,col)(dig) then
				cdn:=cdn+1;
				cdelete(cdn):=(row,col);
			end if;
		end loop;


	end if;



end Xwing;

