
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

-- find hidden [or naked] pairs
procedure hiddenPairs( rcd: cellseq; 
	t1,t2, dt1,dt2,  s1,s2, ds1,ds2: out coorng; 
	found, found2: out boolean) is

type tracetype is array(coorng) of coorng;
 
-- Count/id the cells containing digit f
function d1( f: coorng ) return integer is
	kount: integer := 0;
begin
	for c in coorng loop
		if candidate( rcd(c)(1), rcd(c)(2) )(f) then
			kount:=kount+1;
		end if;
	end loop;
	return kount;
end d1;

-- Count the cells containing  f or s
function d2( f,s: coorng; trace: out tracetype ) return integer is
	kount: integer := 0;
begin

	for c in coorng loop

		if 
			candidate( rcd(c)(1), rcd(c)(2) )(f)
			or
			candidate( rcd(c)(1), rcd(c)(2) )(s) 
		then
			kount:=kount+1;
			trace(kount):=c;
		end if;

	end loop;

	return kount;

end d2;



-- Count the candidate digits contained in the union
-- of First + Second cells in "rcd".
function n2( f,s: coorng ) return integer is
	kount: integer := 0;
begin

	for d in coorng loop

		if 
			candidate( rcd(f)(1), rcd(f)(2) )(d)
			or
			candidate( rcd(s)(1), rcd(s)(2) )(d) 
		then
			kount:=kount+1;
		end if;

	end loop;

	return kount;

end n2;




	type used is array(coorng) of boolean;
	digUsed: used := (others=>false);

	k,j: integer;

	trace: tracetype;

begin --hiddenPairs

	found:=false; t1:=1; t2:=1;

	for first in coorng range 1..9 loop
	if not found and d1(first)=2 then --outer

		for second in coorng range first+1..9 loop
		if not found and d1(second)=2 then --middle

			k:=d2(first,second,trace); -- #cells containing either f or s

			j:=n2( trace(1), trace(2) ); --#digits in Union{f,s}

			if k=2 and j>2 then --found a hidden pair
				found:=true;
				t1:=trace(1); t2:=trace(2);
				dt1:=first; dt2:=second;
				digUsed(first):=true;
				digUsed(second):=true;
			end if; --proceed inner

		end if; --middle
		end loop; --second

	end if; --outer
	end loop; --first


--now, try again in case of a second pair:

	found2:=false; s1:=1; s2:=1;

	for first in coorng range 1..9 loop
	if not found2 and not digUsed(first) and d1(first)=2 then --outer

		for second in coorng range first+1..9 loop
		if not found2 and not digUsed(second) and d1(second)=2 then --middle

			k:=d2(first,second,trace); -- #cells containing either f or s

			j:=n2( trace(1), trace(2) ); --#digits in Union{f,s}

			if k=2 and j>2 then --found another hidden pair
				found2:=true;
				s1:=trace(1); s2:=trace(2);
				ds1:=first; ds2:=second;
			end if;

		end if; --middle
		end loop; --second

	end if; --outer
	end loop; --first



end hiddenPairs;

