
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

-- find hidden triples:
procedure hiddenTriples( rcd: cellseq; 
	t1,t2,t3, dt1,dt2,dt3,
	s1,s2,s3, ds1,ds2,ds3: out coorng; 
	found, found2: out boolean) is


type tracetype is array(coorng) of coorng;
  
-- Count/id the cells containing digit f
function d1( f: coorng ) return integer is
	kount: integer := 0;
begin
	for c in coorng loop
		if candidate( rcd(c)(1), rcd(c)(2) )(f) then
			kount:=kount+1;
		end if;
	end loop;
	return kount;
end d1;

-- Count the cells containing  f or s
--function d2( f,s: coorng; trace: out tracetype ) return integer is
function d2( f,s: coorng ) return integer is
	kount: integer := 0;
begin

	for c in coorng loop

		if 
			candidate( rcd(c)(1), rcd(c)(2) )(f)
			or
			candidate( rcd(c)(1), rcd(c)(2) )(s) 
		then
			kount:=kount+1;
			--trace(kount):=c;
		end if;

	end loop;

	return kount;

end d2;


-- Count the cells containing f or s or t
function d3( f,s,t: coorng; trace: out tracetype ) return integer is
	kount: integer := 0;
begin

	for c in coorng loop

		if 
			candidate( rcd(c)(1), rcd(c)(2) )(f)
			or
			candidate( rcd(c)(1), rcd(c)(2) )(s) 
			or
			candidate( rcd(c)(1), rcd(c)(2) )(t) 
		then
			kount:=kount+1;
			trace(kount):=c; -- #cell in sequence
		end if;

	end loop;

	return kount;

end d3;






-- Count the candidate digits contained in the union
-- of First + Second + Third cells in "rcd".
function n3( f,s,t: coorng ) return integer is
	kount: integer := 0;
begin

	for d in coorng loop

		if 
			candidate( rcd(f)(1), rcd(f)(2) )(d)
			or
			candidate( rcd(s)(1), rcd(s)(2) )(d) 
			or
			candidate( rcd(t)(1), rcd(t)(2) )(d) 
		then
			kount:=kount+1;
		end if;

	end loop;

	return kount;

end n3;





	type used is array(coorng) of boolean;
	digUsed: used := (others=>false);

	n, k, i, j: integer;

	trace: tracetype;

begin --hiddenTriples

	found:=false; t1:=1; t2:=1; t3:=1;

	for first in coorng range 1..9 loop
	if not found then --outer

		n:=d1(first);
		if 2<=n and n<=3 then --proceed outer

		for second in coorng range first+1..9 loop
		if not found and d1(second)>1 then --middle


			k:=d2(first,second); -- #cells w/digits {f,s}

			if k<=3 then --proceed inner

				for third in coorng range second+1..9 loop
				if not found and d1(third)>1 then --core


					i:=d3(first,second,third,trace); 
					-- i is #cells w/digits f or s or t

					j:=n3( trace(1), trace(2), trace(3) );
					-- j is total #digits in Union of cells involved



					if i=3 and j>3 then -- found a hidden triple
						found:=true;
						t1:=trace(1); t2:=trace(2); t3:=trace(3);
						dt1:=first; dt2:=second; dt3:=third;

						digUsed(first):=true;
						digUsed(second):=true;
						digUsed(third):=true;
					end if;

				end if; --core
				end loop; --third

			end if; --proceed inner


		end if; --middle
		end loop; --second
		end if; --proceed outer

	end if; --outer
	end loop; --first


--now, try again in case a second set:

	found2:=false; s1:=1; s2:=1; s3:=1;

	for first in coorng range 1..9 loop
	if not found2 and not digUsed(first) then --outer

		n:=d1(first);
		if 2<=n and n<=3 then --proceed outer
		for second in coorng range first+1..9 loop
		if not found2 and not digUsed(second) and d1(second)>1 then --middle


			k:=d2(first,second); -- #digits in Union{f,s}

			if k<=3 then --proceed inner

				for third in coorng range second+1..9 loop
				if not found2 and not digUsed(third) and d1(third)>1 then --core

					i:=d3(first,second,third,trace); 
					-- i is #cells w/digits f,s,t

					j:=n3( trace(1), trace(2), trace(3) );
					-- j is total #digits in Union of cells involved

					if i=3 and j>3 then -- found a hidden triple
						found2:=true;
						s1:=trace(1); s2:=trace(2); s3:=trace(3);
						ds1:=first; ds2:=second; ds3:=third;

					end if;

				end if; --core
				end loop; --third

			end if; --proceed inner


		end if; --middle
		end loop; --second
		end if; --proceed outer

	end if; --outer
	end loop; --first



end hiddenTriples;

