
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

-- find naked pairs
procedure nakedPairs( rcd: cellseq; 
	t1,t2, s1,s2: out coorng;
	d1,d2, d3,d4: out i9;
	found, found2: out boolean) is


type tracetype is array(coorng) of s9;
 

-- find 2 cells containing only f & s
function f2( f,s: coorng; trace: out tracetype ) return integer is
	kount: integer := 0;
	nootherdigits: boolean;
	row,col: integer;
begin

	trace:=(others=>0);

	for c in coorng loop
	row:=rcd(c)(1);
	col:=rcd(c)(2);
	if m9(row,col)=0 then --proceed

		nootherdigits:=true;
		for d in 1..9 loop
			if d/=f and d/=s then
				if candidate(row,col)(d) then
					nootherdigits:=false;
				end if;
			end if;
		end loop; --d

		if 
			candidate(row,col)(f)
			and
			candidate(row,col)(s)
			and
			nootherdigits
		then
			kount:=kount+1;
			trace(kount):=c;
		end if;

	end if; --m9=0
	end loop;

	return kount;

end f2;







	type used is array(coorng) of boolean;
	digUsed: used := (others=>false);

	trace: tracetype := (others=>0);

begin --nakedPairs

	found:=false; t1:=1; t2:=1;

	for dig1 in coorng range 1..9 loop
	if not found then --outer

		for dig2 in coorng range dig1+1..9 loop
		if not found then --middle

			if 2=f2(dig1,dig2,trace) then
				found:=true;
				t1:=trace(1); t2:=trace(2);
				digUsed(dig1):=true;
				digUsed(dig2):=true;
				d1:=dig1; d2:=dig2;
			end if; --proceed inner

		end if; --middle
		end loop; --dig2

	end if; --outer
	end loop; --dig1


--now, try again in case of a dig2 pair:

	found2:=false; s1:=1; s2:=1;

	for dig1 in coorng range 1..9 loop 
	if not found2 and not digUsed(dig1) then --outer

		for dig2 in coorng range dig1+1..9 loop
		if not found2 and not digUsed(dig2) then --middle

			if 2=f2(dig1,dig2,trace) then
				found2:=true;
				s1:=trace(1); s2:=trace(2);
				d3:=dig1; d4:=dig2;
			end if;

		end if; --middle
		end loop; --dig2

	end if; --outer
	end loop; --dig1



end nakedPairs;

