
--subtype coorng is integer range 1..9;
--type coords is array(1..2) of coorng;
--type cellseq is array(1..9) of coords;


separate( asudx )

procedure nakedTriples( rcd: cellseq; 
	t1,t2,t3,
	s1,s2,s3: out coorng; 
	d1,d2,d3, d4,d5,d6: out i9;
	found, found2: out boolean) is


type tracetype is array(coorng) of s9; --coorng;



-- find 3 cells containing only f or s or t
function f3( f,s,t: coorng; trace: out tracetype ) return integer is
	kount: integer := 0;
	nootherdigits, okf, oks, okt, yesf,yess,yest: boolean := false;
	row,col: integer;
begin

	trace:=(others=>0);

	for c in coorng loop -- traverse the cells in this house
	row:=rcd(c)(1);
	col:=rcd(c)(2);
	if m9(row,col)=0 then --proceed, not a single

		nootherdigits:=true;
		for d in 1..9 loop
			if d/=f and d/=s and d/=t then
				if candidate(row,col)(d) then
					nootherdigits:=false;
				end if;
			end if;
		end loop; --d

		if nootherdigits then --proceed, this cell is clean

			yesf:=false; yess:=false; yest:=false;
			if candidate( rcd(c)(1), rcd(c)(2) )(f) then yesf:=true; end if;
			if candidate( rcd(c)(1), rcd(c)(2) )(s) then yess:=true; end if;
			if candidate( rcd(c)(1), rcd(c)(2) )(t) then yest:=true; end if;


			if yesf or yess or yest then

				kount:=kount+1;
				trace(kount):=c; -- #cell in sequence

				if yesf then okf:=true; end if;
				if yess then oks:=true; end if;
				if yest then okt:=true; end if;

			end if;

		end if; --nootherdigits

	end if; --not single
	end loop; --c

	if okf and oks and okt then
		return kount;
	else
		return 0;
	end if;

end f3;






	type used is array(coorng) of boolean;
	digUsed: used := (others=>false);

	trace: tracetype;

begin --findTriples

	found:=false; t1:=1; t2:=1; t3:=1;

	for dig1 in coorng range 1..9 loop
	if not found then --outer

		for dig2 in coorng range dig1+1..9 loop
		if not found  then --middle

			for dig3 in coorng range dig2+1..9 loop
			if not found then --inner

				if 3=f3(dig1,dig2,dig3,trace) then
					found:=true;
					t1:=trace(1); t2:=trace(2); t3:=trace(3);
					digUsed(dig1):=true;
					digUsed(dig2):=true;
					digUsed(dig3):=true;
					d1:=dig1; d2:=dig2; d3:=dig3;
				end if;

			end if; --core
			end loop; --dig3

		end if; --middle
		end loop; --dig2

	end if; --outer
	end loop; --dig1


--now, try again in case of a dig2 set:

	found2:=false; s1:=1; s2:=1; s3:=1;

	for dig1 in coorng range 1..9 loop
	if not found2 and not digUsed(dig1) then --outer

		for dig2 in coorng range dig1+1..9 loop
		if not found2 and not digUsed(dig2) then --middle

			for dig3 in coorng range dig2+1..9 loop
			if not found2 and not digUsed(dig3) then --core

				if 3=f3(dig1,dig2,dig3,trace) then -- found a naked triple
					found2:=true;
					s1:=trace(1); s2:=trace(2); s3:=trace(3);
					d4:=dig1; d5:=dig2; d6:=dig3;
				end if;

			end if; --core
			end loop; --dig3

		end if; --middle
		end loop; --dig2

	end if; --outer
	end loop; --dig1



end nakedTriples;

