#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- help_menu.tcl --
#
### Callback functions of "Help" menu. ########################################
#
# @cb_helpmenu_about
#
proc cb_helpmenu_about {} {
    global RES BINDIR
    global M3014
    global M9003 M9004 M9005 M9006

    toplevel .dlg
    wm transient .dlg
    wm title .dlg $M3014
    wm protocol .dlg WM_DELETE_WINDOW {set RES "ok"}
    wm resizable .dlg 0 0

    frame .dlg.f -relief groove -bd 2
    pack  .dlg.f -padx 2 -pady 2 -expand 1 -fill both
    
      frame .dlg.f.f1
      pack  .dlg.f.f1 -padx 2 -pady 1 -expand 1 -fill x
        frame .dlg.f.f1.f1
        pack  .dlg.f.f1.f1 -padx 2 -pady 1 -expand 0 -fill both -side left \
                           -anchor c
          pack [canvas .dlg.f.f1.f1.can -width 32 -height 32] -expand 0 \
                                                              -fill both
          .dlg.f.f1.f1.can create image 0 0  -anchor nw \
                      -image [xpm-to-image [file join $BINDIR icon atedit.xpm]]
        frame .dlg.f.f1.f2
        pack  .dlg.f.f1.f2 -padx 2 -pady 1 -expand 1 -fill x -side left
          label .dlg.f.f1.f2.l1 -text $M9003
          pack  .dlg.f.f1.f2.l1 -expand 0 -fill x -anchor w
          label .dlg.f.f1.f2.l2 -text $M9004
          pack  .dlg.f.f1.f2.l2 -expand 0 -fill x -anchor w

      frame .dlg.f.f3
      pack  .dlg.f.f3 -padx 2 -pady 1 -expand 1 -fill x
        label .dlg.f.f3.l -text $M9005
        pack  .dlg.f.f3.l -expand 1 -fill x -anchor c
      frame .dlg.f.f4
      pack  .dlg.f.f4 -padx 2 -pady 1 -expand 1 -fill x
        label .dlg.f.f4.l -text $M9006
        pack  .dlg.f.f4.l -expand 1 -fill x -anchor c

    Separator .dlg.s1 -orient horizontal
    pack .dlg.s1 -pady 4 -expand 1 -fill x

    button .dlg.okbtn -text " OK " -width 8 -command {set RES "ok"}
    .dlg.okbtn configure -default active
    bind .dlg.okbtn <Return> {
        set RES "ok"
    }
    pack .dlg.okbtn

    ::tk::SetFocusGrab .dlg .dlg.okbtn

    vwait RES

    ::tk::RestoreFocusGrab .dlg .dlg.okbtn destroy
}
