#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- tools_menu.tcl --
# This code is contributed by Luca Francesconi<luca@>.
#
### Callback functions of "Tools" menu. ########################################
#
#------------------------------------------------------------------------------
# @cb_tools_date
#------------------------------------------------------------------------------
proc cb_tools_date {} {
    global USR_CNF_LANG

    switch $USR_CNF_LANG {
        "ja" {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %Y/%m/%d]
        }
        "it" {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %d/%m/%Y]
        }
        default {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %m/%d/%Y]
        }
    }
}
#------------------------------------------------------------------------------
# @cb_tools_time
#------------------------------------------------------------------------------
proc cb_tools_time {} {
    global USR_CNF_LANG

    switch $USR_CNF_LANG {
        "ja" {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %H:%M:%S]
        }
        "it" {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %H:%M:%S]
        }
        default {
            .base.textarea insert insert \
                           [clock format [clock seconds] -format %H:%M:%S]
        }
    }
}
