/*****************************************************************************
 *
 *   sh4.h
 *   Portable Hitachi SH-4 (SH7750 family) emulator interface
 *
 *   By R. Belmont, based on sh2.c by Juergen Buchmueller, Mariusz Wojcieszek,
 *      Olivier Galibert, Sylvain Glaize, and James Forshaw.
 *
 *****************************************************************************/

#ifndef _SH4_H
#define _SH4_H

#include "cpuintrf.h"

#define SH4_INT_NONE	-1
enum {
	SH4_IRL0=0, SH4_IRL1, SH4_IRL2, SH4_IRL3, SH4_IRLn
};

enum {
	SH4_PC=1, SH4_SR, SH4_PR, SH4_GBR, SH4_VBR, SH4_DBR, SH4_MACH, SH4_MACL,
	SH4_R0, SH4_R1, SH4_R2, SH4_R3, SH4_R4, SH4_R5, SH4_R6, SH4_R7,
	SH4_R8, SH4_R9, SH4_R10, SH4_R11, SH4_R12, SH4_R13, SH4_R14, SH4_R15, SH4_EA,
	SH4_R0_BK0, SH4_R1_BK0, SH4_R2_BK0, SH4_R3_BK0, SH4_R4_BK0, SH4_R5_BK0, SH4_R6_BK0, SH4_R7_BK0,
	SH4_R0_BK1, SH4_R1_BK1, SH4_R2_BK1, SH4_R3_BK1, SH4_R4_BK1, SH4_R5_BK1, SH4_R6_BK1, SH4_R7_BK1,
	SH4_SPC, SH4_SSR, SH4_SGR, SH4_FPSCR, SH4_FPUL, SH4_FR0, SH4_FR1, SH4_FR2, SH4_FR3, SH4_FR4, SH4_FR5,
	SH4_FR6, SH4_FR7, SH4_FR8, SH4_FR9, SH4_FR10, SH4_FR11, SH4_FR12, SH4_FR13, SH4_FR14, SH4_FR15,
	SH4_XF0, SH4_XF1, SH4_XF2, SH4_XF3, SH4_XF4, SH4_XF5, SH4_XF6, SH4_XF7,
	SH4_XF8, SH4_XF9, SH4_XF10, SH4_XF11, SH4_XF12, SH4_XF13, SH4_XF14, SH4_XF15
};

enum {
	SH4_INTC_NMI=23, SH4_INTC_IRLn0, SH4_INTC_IRLn1, SH4_INTC_IRLn2, SH4_INTC_IRLn3, SH4_INTC_IRLn4,
	SH4_INTC_IRLn5, SH4_INTC_IRLn6, SH4_INTC_IRLn7, SH4_INTC_IRLn8, SH4_INTC_IRLn9, SH4_INTC_IRLnA,
	SH4_INTC_IRLnB, SH4_INTC_IRLnC, SH4_INTC_IRLnD, SH4_INTC_IRLnE, SH4_INTC_IRL0, SH4_INTC_IRL1,
	SH4_INTC_IRL2, SH4_INTC_IRL3, SH4_INTC_HUDI, SH4_INTC_GPOI, SH4_INTC_DMTE0, SH4_INTC_DMTE1,
	SH4_INTC_DMTE2, SH4_INTC_DMTE3, SH4_INTC_DMTE4, SH4_INTC_DMTE5, SH4_INTC_DMTE6, SH4_INTC_DMTE7,
	SH4_INTC_DMAE, SH4_INTC_TUNI3, SH4_INTC_TUNI4, SH4_INTC_TUNI0, SH4_INTC_TUNI1, SH4_INTC_TUNI2,
	SH4_INTC_TICPI2, SH4_INTC_ATI, SH4_INTC_PRI, SH4_INTC_CUI, SH4_INTC_SCI1ERI, SH4_INTC_SCI1RXI,
	SH4_INTC_SCI1TXI, SH4_INTC_SCI1TEI, SH4_INTC_SCIFERI, SH4_INTC_SCIFRXI, SH4_INTC_SCIFBRI,
	SH4_INTC_SCIFTXI, SH4_INTC_ITI, SH4_INTC_RCMI, SH4_INTC_ROVI
};

enum
{
	CPUINFO_INT_SH4_FRT_INPUT = CPUINFO_INT_CPU_SPECIFIC
};

enum
{
	CPUINFO_PTR_SH4_FTCSR_READ_CALLBACK = CPUINFO_PTR_CPU_SPECIFIC,
};

struct sh4_config
{
  int md2;
  int md1;
  int md0;
  int md6;
  int md4;
  int md3;
  int md5;
  int md7;
  int md8;
  int clock;
};

extern void sh4_get_info(UINT32 state, cpuinfo *info);

WRITE32_HANDLER( sh4_internal_w );
READ32_HANDLER( sh4_internal_r );

#ifdef MAME_DEBUG
extern unsigned DasmSH4( char *dst, unsigned pc, UINT16 opcode );
#endif

#endif /* _SH4_H */

