/*
 * Decompiled with CFR 0.152.
 */
package org.hkzo.atnd4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import org.hkzo.atnd4j.EventsResult;

public class Atnd {
    protected static final String API_EVENTS = "http://api.atnd.org/events/?format=json&";
    protected static final String API_EVENTS_USERS = "http://api.atnd.org/events/users/?format=json&";
    private int connectTimeout = 8000;
    private int readTimeout = 8000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventsResult callApi(String api, String query) throws IllegalArgumentException, SocketTimeoutException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        boolean isDebug = logger.isLoggable(Level.FINE);
        if (api == null || api.equals("")) {
            throw new IllegalArgumentException("api param is null.");
        }
        if (query == null) {
            throw new IllegalArgumentException("query param is null.");
        }
        EventsResult res = null;
        HttpURLConnection con = null;
        InputStream ins = null;
        try {
            if (isDebug) {
                logger.fine("Request URL=[" + api + query + "]");
            }
            con = this.getURLConnection(api + query);
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "atnd4j/0.1.0");
            con.setConnectTimeout(this.connectTimeout);
            con.setReadTimeout(this.readTimeout);
            if (isDebug) {
                logger.fine("set ConnectTimeout=" + con.getConnectTimeout() + ", ReadTimeout=" + con.getReadTimeout());
            }
            con.connect();
            if (con.getResponseCode() == 200) {
                ins = con.getInputStream();
                res = (EventsResult)JSON.decode((InputStream)ins, EventsResult.class);
            } else {
                logger.warning("connect error: ResponseCode=" + con.getResponseCode() + ", URL=[" + api + query + "]");
            }
        }
        catch (JSONException e) {
            logger.warning("JSONException: ErrorCode=" + e.getErrorCode() + ", MSG=" + e.getMessage());
        }
        finally {
            try {
                if (ins != null) {
                    ins.close();
                }
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (IOException e1) {}
        }
        if (res == null) {
            res = new EventsResult();
        }
        return res;
    }

    protected HttpURLConnection getURLConnection(String url) throws IOException {
        URL u = new URL(url);
        return (HttpURLConnection)u.openConnection();
    }

    public EventsResult getEvents(String query) throws IllegalArgumentException, SocketTimeoutException, IOException {
        return this.callApi(API_EVENTS, query);
    }

    public EventsResult getEventsUsers(String query) throws IllegalArgumentException, SocketTimeoutException, IOException {
        return this.callApi(API_EVENTS_USERS, query);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

