/*
 * Copyright 2010 Project atnd4j
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hkzo.atnd4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * イベント情報クラスです。
 */
public class Event implements Serializable {
	private static final long serialVersionUID = 1L;
	private long eventId;
	private String title = "";
	private String catch_ = "";
	private String description = "";
	private String eventUrl = "";
	private Date startedAt;
	private Date endedAt;
	private String url = "";
	private long limit;
	private String address = "";
	private String place = "";
	private double lat;
	private double lon;
	private long ownerId;
	private String ownerNickname = "";
	private String ownerTwitterId = "";
	private String ownerTwitterImg = "";
	private long accepted;
	private long waiting;
	private Date updatedAt;
	private List<User> users = new ArrayList<User>();
	/**
	 * @return the eventId
	 */
	public long getEventId() {
		return eventId;
	}
	/**
	 * @param eventId the eventId to set
	 */
	public void setEventId(long eventId) {
		this.eventId = eventId;
	}
	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * @return the catch
	 */
	public String getCatch() {
		return catch_;
	}
	/**
	 * @param s the catch to set
	 */
	public void setCatch(String s) {
		this.catch_ = s;
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	/**
	 * @return the eventUrl
	 */
	public String getEventUrl() {
		return eventUrl;
	}
	/**
	 * @param eventUrl the eventUrl to set
	 */
	public void setEventUrl(String eventUrl) {
		this.eventUrl = eventUrl;
	}
	/**
	 * @return the startedAt
	 */
	public Date getStartedAt() {
		return startedAt;
	}
	/**
	 * @param startedAt the startedAt to set
	 */
	public void setStartedAt(Date startedAt) {
		this.startedAt = startedAt;
	}
	/**
	 * @return the endedAt
	 */
	public Date getEndedAt() {
		return endedAt;
	}
	/**
	 * @param endedAt the endedAt to set
	 */
	public void setEndedAt(Date endedAt) {
		this.endedAt = endedAt;
	}
	/**
	 * @return the url
	 */
	public String getUrl() {
		return url;
	}
	/**
	 * @param url the url to set
	 */
	public void setUrl(String url) {
		this.url = url;
	}
	/**
	 * @return the limit
	 */
	public long getLimit() {
		return limit;
	}
	/**
	 * @param limit the limit to set
	 */
	public void setLimit(long limit) {
		this.limit = limit;
	}
	/**
	 * @return the address
	 */
	public String getAddress() {
		return address;
	}
	/**
	 * @param address the address to set
	 */
	public void setAddress(String address) {
		this.address = address;
	}
	/**
	 * @return the place
	 */
	public String getPlace() {
		return place;
	}
	/**
	 * @param place the place to set
	 */
	public void setPlace(String place) {
		this.place = place;
	}
	/**
	 * @return the lat
	 */
	public double getLat() {
		return lat;
	}
	/**
	 * @param lat the lat to set
	 */
	public void setLat(double lat) {
		this.lat = lat;
	}
	/**
	 * @return the lon
	 */
	public double getLon() {
		return lon;
	}
	/**
	 * @param lon the lon to set
	 */
	public void setLon(double lon) {
		this.lon = lon;
	}
	/**
	 * @return the ownerId
	 */
	public long getOwnerId() {
		return ownerId;
	}
	/**
	 * @param ownerId the ownerId to set
	 */
	public void setOwnerId(long ownerId) {
		this.ownerId = ownerId;
	}
	/**
	 * @return the ownerNickname
	 */
	public String getOwnerNickname() {
		return ownerNickname;
	}
	/**
	 * @param ownerNickname the ownerNickname to set
	 */
	public void setOwnerNickname(String ownerNickname) {
		this.ownerNickname = ownerNickname;
	}
	/**
	 * @return the ownerTwitterId
	 */
	public String getOwnerTwitterId() {
		return ownerTwitterId;
	}
	/**
	 * @param ownerTwitterId the ownerTwitterId to set
	 */
	public void setOwnerTwitterId(String ownerTwitterId) {
		this.ownerTwitterId = ownerTwitterId;
	}
	/**
	 * @return the ownerTwitterImg
	 */
	public String getOwnerTwitterImg() {
		return ownerTwitterImg;
	}
	/**
	 * @param ownerTwitterImg the ownerTwitterImg to set
	 */
	public void setOwnerTwitterImg(String ownerTwitterImg) {
		this.ownerTwitterImg = ownerTwitterImg;
	}
	/**
	 * @return the accepted
	 */
	public long getAccepted() {
		return accepted;
	}
	/**
	 * @param accepted the accepted to set
	 */
	public void setAccepted(long accepted) {
		this.accepted = accepted;
	}
	/**
	 * @return the waiting
	 */
	public long getWaiting() {
		return waiting;
	}
	/**
	 * @param waiting the waiting to set
	 */
	public void setWaiting(long waiting) {
		this.waiting = waiting;
	}
	/**
	 * @return the updatedAt
	 */
	public Date getUpdatedAt() {
		return updatedAt;
	}
	/**
	 * @param updatedAt the updatedAt to set
	 */
	public void setUpdatedAt(Date updatedAt) {
		this.updatedAt = updatedAt;
	}
	/**
	 * @return the users
	 */
	public List<User> getUsers() {
		return users;
	}
	/**
	 * @param users the users to set
	 */
	public void setUsers(List<User> users) {
		this.users = users;
	}
}
