/*
 * Copyright 2010 Project atnd4j
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hkzo.atnd4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * APIのレスポンス格納クラスです。
 */
public class EventsResult implements Serializable {
	private static final long serialVersionUID = 1L;
	private long resultsReturned;
	private long resultsAvailable;
	private long resultsStart;
	private List<Event> events = new ArrayList<Event>();
	/**
	 * @return the resultsReturned
	 */
	public long getResultsReturned() {
		return resultsReturned;
	}
	/**
	 * @param resultsReturned the resultsReturned to set
	 */
	public void setResultsReturned(long resultsReturned) {
		this.resultsReturned = resultsReturned;
	}
	/**
	 * @return the resultsAvailable
	 */
	public long getResultsAvailable() {
		return resultsAvailable;
	}
	/**
	 * @param resultsAvailable the resultsAvailable to set
	 */
	public void setResultsAvailable(long resultsAvailable) {
		this.resultsAvailable = resultsAvailable;
	}
	/**
	 * @return the resultsStart
	 */
	public long getResultsStart() {
		return resultsStart;
	}
	/**
	 * @param resultsStart the resultsStart to set
	 */
	public void setResultsStart(long resultsStart) {
		this.resultsStart = resultsStart;
	}
	/**
	 * @return the events
	 */
	public List<Event> getEvents() {
		return events;
	}
	/**
	 * @param events the events to set
	 */
	public void setEvents(List<Event> events) {
		this.events = events;
	}

}
