#cs #INDEX# --------------------------------------------------------------------

 Title         : autest
 AuTest Version: 0.99.0
 Author        : Takazumi Shirayanagi

#ce ----------------------------------------------------------------------------

#include-once

#cs #VARIABLE# -----------------------------------------------------------------
#ce ----------------------------------------------------------------------------

; Variable
Global $AUTEST_VERSION = "0.9.0"

; Test
Global $autest_result = 0

; Option

; output file location type
; 0 = gcc
; 1 = Visual Studio
Global $autest_output_compilerfilelocation = 0

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	OPTIONAL FUNCTION
 * @public
 * AutestSetOption
#ce ----------------------------------------------------------------------------

#cs #CURRENT# ------------------------------------------------------------------
 * @brief	ASSETION FUNCTION
 * @public
 * AUTEST_ASSERT_TRUE
 * AUTEST_EXPECT_TRUE
 * AUTEST_ASSERT_FALSE
 * AUTEST_EXPECT_FALSE
 * AUTEST_ASSERT_EQ
 * AUTEST_EXPECT_EQ
 * AUTEST_ASSERT_NE
 * AUTEST_EXPECT_NE
 * AUTEST_ASSERT_LT
 * AUTEST_EXPECT_LT
 * AUTEST_ASSERT_LE
 * AUTEST_EXPECT_LE
 * AUTEST_ASSERT_GT
 * AUTEST_EXPECT_GT
 * AUTEST_ASSERT_GE
 * AUTEST_EXPECT_GE
 * AUTEST_ASSERT_STREQ
 * AUTEST_EXPECT_STREQ
 * AUTEST_ASSERT_STRNE
 * AUTEST_EXPECT_STRNE
 * AUTEST_ASSERT_STRCASEEQ
 * AUTEST_EXPECT_STRCASEEQ
 * AUTEST_ASSERT_STRCASENE
 * AUTEST_EXPECT_STRCASENE
#ce ----------------------------------------------------------------------------

;
; AUTEST_*_TRUE
;
Func AUTEST_ASSERT_TRUE($value, $statement="", $file="", $line=-1)
	$statement = AUTEST_GetExpression($statement, $value)
	IF Not $value == TRUE Then
		AUTEST_ASSERT_(AUTEST_BooleanFailureMessage(TRUE, $statement, $value), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_TRUE($value, $statement="", $file="", $line=-1)
	$statement = AUTEST_GetExpression($statement, $value)
	IF Not $value == TRUE Then
		AUTEST_EXPECT_(AUTEST_BooleanFailureMessage(TRUE, $statement, $value), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_FALSE
;
Func AUTEST_ASSERT_FALSE($value, $statement="", $file="", $line=-1)
	$statement = AUTEST_GetExpression($statement, $value)
	IF Not $value == FALSE Then
		AUTEST_ASSERT_(AUTEST_BooleanFailureMessage(FALSE, $statement, $value), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_FALSE($value, $statement="", $file="", $line=-1)
	$statement = AUTEST_GetExpression($statement, $value)
	IF Not $value == FALSE Then
		AUTEST_EXPECT_(AUTEST_BooleanFailureMessage(FALSE, $statement, $value), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_EQ
;
Func AUTEST_ASSERT_EQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not ($expected == $actual) Then
		AUTEST_ASSERT_(AUTEST_EqFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_EQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not ($expected == $actual) Then
		AUTEST_EXPECT_(AUTEST_EqFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_NE
;
Func AUTEST_ASSERT_NE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF ($val1 == $val2) Then
		AUTEST_ASSERT_(AUTEST_VsFailureMessage($val1_str, $val1, "!=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_NE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF ($val1 == $val2) Then
		AUTEST_EXPECT_(AUTEST_VsFailureMessage($val1_str, $val1, "!=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_LT
;
Func AUTEST_ASSERT_LT($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 < $val2) Then
		AUTEST_ASSERT_(AUTEST_VsFailureMessage($val1_str, $val1, "<", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_LT($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 < $val2) Then
		AUTEST_EXPECT_(AUTEST_VsFailureMessage($val1_str, $val1, "<", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_LE
;
Func AUTEST_ASSERT_LE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 <= $val2) Then
		AUTEST_ASSERT_(AUTEST_VsFailureMessage($val1_str, $val1, "<=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_LE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 <= $val2) Then
		AUTEST_EXPECT_(AUTEST_VsFailureMessage($val1_str, $val1, "<=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_GT
;
Func AUTEST_ASSERT_GT($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 > $val2) Then
		AUTEST_ASSERT_(AUTEST_VsFailureMessage($val1_str, $val1, ">", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_GT($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 > $val2) Then
		AUTEST_EXPECT_(AUTEST_VsFailureMessage($val1_str, $val1, ">", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_GE
;
Func AUTEST_ASSERT_GE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 >= $val2) Then
		AUTEST_ASSERT_(AUTEST_VsFailureMessage($val1_str, $val1, ">=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_GE($val1, $val2, $val1_str="", $val2_str="", $file="", $line=-1)
	$val1_str = AUTEST_GetExpression($val1_str, $val1)
	$val2_str = AUTEST_GetExpression($val2_str, $val2)
	IF Not ( $val1 >= $val2) Then
		AUTEST_EXPECT_(AUTEST_VsFailureMessage($val1_str, $val1, ">=", $val2_str, $val2), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_STREQ
;
Func AUTEST_ASSERT_STREQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not StringCompare($expected, $actual, 1) == 0 Then
		AUTEST_ASSERT_(AUTEST_StrEqFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_STREQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not (StringCompare($expected, $actual, 1) == 0) Then
		AUTEST_EXPECT_(AUTEST_StrEqFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_STRNE
;
Func AUTEST_ASSERT_STRNE($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF StringCompare($expected, $actual, 1) == 0 Then
		AUTEST_ASSERT_(AUTEST_StrNeFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_STRNE($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF (StringCompare($expected, $actual, 1) == 0) Then
		AUTEST_EXPECT_(AUTEST_StrNeFailureMessage($expected_str, $expected, $actual_str, $actual), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_STRCASEEQ
;
Func AUTEST_ASSERT_STRCASEEQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not (StringCompare($expected, $actual) == 0) Then
		AUTEST_ASSERT_(AUTEST_StrEqFailureMessage($expected_str, $expected, $actual_str, $actual, " (ignoring case)"), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_STRCASEEQ($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF Not (StringCompare($expected, $actual) == 0) Then
		AUTEST_EXPECT_(AUTEST_StrEqFailureMessage($expected_str, $expected, $actual_str, $actual, " (ignoring case)"), $file, $line)
	EndIf
EndFunc

;
; AUTEST_*_STRCASENE
;
Func AUTEST_ASSERT_STRCASENE($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF (StringCompare($expected, $actual) == 0) Then
		AUTEST_ASSERT_(AUTEST_StrNeFailureMessage($expected_str, $expected, $actual_str, $actual, " (ignoring case)"), $file, $line)
	EndIf
EndFunc

Func AUTEST_EXPECT_STRCASENE($expected, $actual, $expected_str="", $actual_str="", $file="", $line=-1)
	$expected_str = AUTEST_GetExpression($expected_str, $expected)
	$actual_str = AUTEST_GetExpression($actual_str, $actual)
	IF (StringCompare($expected, $actual) == 0) Then
		AUTEST_EXPECT_(AUTEST_StrNeFailureMessage($expected_str, $expected, $actual_str, $actual, " (ignoring case)"), $file, $line)
	EndIf
EndFunc

;
; AutestSetOption
;
Func AutestSetOption($option_str, $option_value)
	IF $option_str == "filelocation" Then
		IF IsString($option_value) Then
			IF StringCompare($option_value, "gcc") == 0 Then
				$autest_output_compilerfilelocation = 0
			ElseIf StringCompare($option_value, "vs") == 0 Then
				$autest_output_compilerfilelocation = 1
			EndIf
		Else
			IF $option_value == 0 OR $option_value == 1 Then
				$autest_output_compilerfilelocation = $option_value
			EndIf
		EndIf
	EndIf
EndFunc

#cs #INTERNAL_USE_ONLY# --------------------------------------------------------
 * @private
 * AUTEST_ConsolePrint
 * AUTEST_ASSERT_
 * AUTEST_EXPECT_
 * AUTEST_EqFailureMessage
 * AUTEST_StrEqFailureMessage
 * AUTEST_StrNeFailureMessage
 * AUTEST_BooleanFailureMessage
 * AUTEST_VsFailureMessage
 * AUTEST_FormatCompilerFileLocation
 * AUTEST_GetExpression
#ce ----------------------------------------------------------------------------
Func AUTEST_ConsolePrint($str)
	ConsoleWrite($str)
	ConsoleWrite(@CRLF)
EndFunc

Func AUTEST_ASSERT_($msg, $file, $line)
	AUTEST_EXPECT_($msg, $file, $line)
	Exit 1
EndFunc

Func AUTEST_EXPECT_($msg, $file, $line)
	AUTEST_ConsolePrint(AUTEST_FormatCompilerFileLocation($file, $line))
	AUTEST_ConsolePrint($msg)
	$autest_result = 1
EndFunc

Func AUTEST_EqFailureMessage($expected_str, $expected, $actual_str, $actual)
	Local $msg = "error: Value of " & $actual_str & @CRLF & "  Actual: " & String($actual) & @CRLF & "Expected: " & $expected_str
	IF StringCompare($expected_str, String($expected)) Then
		$msg &= @CRLF & "Which is: " & String($expected)
	EndIf
	Return $msg & @CRLF
EndFunc

Func AUTEST_StrEqFailureMessage($expected_str, $expected, $actual_str, $actual, $ignorecase="")
	Local $msg = "error: Value of " & $actual_str & @CRLF & "  Actual: """ & String($actual) & """" & @CRLF & "Expected: " & $expected_str
	IF StringCompare($expected_str, String($expected)) Then
		$msg &= @CRLF & "Which is: """ & String($expected) & """"
	EndIf
	Return $msg & $ignorecase & @CRLF
EndFunc

Func AUTEST_StrNeFailureMessage($val1_str, $val1, $val2_str, $val2, $ignorecase="")
	Local $msg = "error: Expected of : " & $val1_str & " != " & $val2_str &  $ignorecase & @CRLF
	$msg &= "  Actual: """ & String($val1) & """ vs """ & String($val2) & """"
	Return $msg & @CRLF
EndFunc

Func AUTEST_BooleanFailureMessage($expected_str, $actual_str, $actual)
	Return AUTEST_EqFailureMessage($expected_str, $expected_str, $actual_str, $actual)
EndFunc

Func AUTEST_VsFailureMessage($val1_str, $val1, $op, $val2_str, $val2)
	Local $msg = "error: Expected of : " & $val1_str & " " & $op & " " & $val2_str & @CRLF
	$msg &= "  Actual: " & String($val1) & " vs " & String($val2)
	Return $msg & @CRLF
EndFunc

Func AUTEST_FormatCompilerFileLocation($file, $line)
	Local $msg = ""
	IF StringLen($file) == 0 Then
		$msg = "Unkown file"
	Else
		$msg = $file
	EndIf

	IF $line >= 0 Then
		IF $autest_output_compilerfilelocation == 0 Then
			$msg &= ":" & String($line)
		Else
			$msg &= "(" & String($line) & ")"
		EndIf
	EndIf

	Return $msg
EndFunc

Func AUTEST_GetExpression($statement, $value)
	IF StringLen($statement) == 0 Then
		Return String($value)
	EndIf
	Return $statement
EndFunc
