/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		autest.h
 * @brief		autest }N` t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2012-2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_AUTEST_H_
#define INCG_AUTEST_H_

#include "autest_pp.h"

/**
 * @private
 * @{
*/
#define AUTEST_TEST_FUNCNAME_(testcase_, testname_)	AUTEST_PP_CAT(AUTEST_PP_CAT(testcase_, _), testname_)
/**
 * @}
*/


/**
 * @brief	eXg}N
 * @{
*/

#if 1

#define AUTEST_TEST(testcase_, testname_)	__sharp__OnAutoItStartRegister			\
	AUTEST_PP_TOSTRING( AUTEST_PP_CAT(testcase_, testname_)_AddTestCase )			\
	__lf__Func AUTEST_PP_CAT(AUTEST_PP_CAT(testcase_, testname_),_AddTestCase())	\
	__lf__	Autest_AddTest(#testcase_, #testname_)									\
	__lf__EndFunc																	\
	__lf__Func AUTEST_TEST_FUNCNAME_(testcase_, testname_)()						\

#else

#define AUTEST_TEST(testcase_, testname_)	__sharp__OnAutoItStartRegister			\
	AUTEST_PP_TOSTRING( AUTEST_TEST_FUNCNAME_(testcase_, testname_) )				\
	__lf__Func AUTEST_TEST_FUNCNAME_(testcase_, testname_)()						\

#endif


#define AUTEST_TEST_END()					EndFunc


/**
 * @}
*/

/**
 * @brief	AT[V}N
 * @{
*/

#define AUTEST_ASSERT_TRUE(statement, ...)		AUTEST_ASSERT_TRUE(statement, #statement, __FILE__, __LINE__)
#define AUTEST_EXPECT_TRUE(statement, ...)		AUTEST_EXPECT_TRUE(statement, #statement, __FILE__, __LINE__)

#define AUTEST_ASSERT_FALSE(statement, ...)		AUTEST_ASSERT_FALSE(statement, #statement, __FILE__, __LINE__)
#define AUTEST_EXPECT_FALSE(statement, ...)		AUTEST_EXPECT_FALSE(statement, #statement, __FILE__, __LINE__)

#define AUTEST_ASSERT_EQ(expected, actual)		AUTEST_ASSERT_EQ(expected, actual, #expected, #actual, __FILE__, __LINE__)
#define AUTEST_EXPECT_EQ(expected, actual)		AUTEST_EXPECT_EQ(expected, actual, #expected, #actual, __FILE__, __LINE__)
#define AUTEST_ASSERT_NE(val1, val2)			AUTEST_ASSERT_NE(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_EXPECT_NE(val1, val2)			AUTEST_EXPECT_NE(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_ASSERT_LT(val1, val2)			AUTEST_ASSERT_LT(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_EXPECT_LT(val1, val2)			AUTEST_EXPECT_LT(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_ASSERT_LE(val1, val2)			AUTEST_ASSERT_LE(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_EXPECT_LE(val1, val2)			AUTEST_EXPECT_LE(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_ASSERT_GT(val1, val2)			AUTEST_ASSERT_GT(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_EXPECT_GT(val1, val2)			AUTEST_EXPECT_GT(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_ASSERT_GE(val1, val2)			AUTEST_ASSERT_GE(val1, val2, #val1, #val2, __FILE__, __LINE__)
#define AUTEST_EXPECT_GE(val1, val2)			AUTEST_EXPECT_GE(val1, val2, #val1, #val2, __FILE__, __LINE__)


#define AUTEST_ASSERT_STREQ(str1, str2, ...)	AUTEST_ASSERT_STREQ(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_EXPECT_STREQ(str1, str2, ...)	AUTEST_EXPECT_STREQ(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_ASSERT_STRNE(str1, str2, ...)	AUTEST_ASSERT_STRNE(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_EXPECT_STRNE(str1, str2, ...)	AUTEST_EXPECT_STRNE(str1, str2, #str1, #str2, __FILE__, __LINE__)

#define AUTEST_ASSERT_STRCASEEQ(str1, str2, ...)	AUTEST_ASSERT_STRCASEEQ(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_EXPECT_STRCASEEQ(str1, str2, ...)	AUTEST_EXPECT_STRCASEEQ(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_ASSERT_STRCASENE(str1, str2, ...)	AUTEST_ASSERT_STRCASENE(str1, str2, #str1, #str2, __FILE__, __LINE__)
#define AUTEST_EXPECT_STRCASENE(str1, str2, ...)	AUTEST_EXPECT_STRCASENE(str1, str2, #str1, #str2, __FILE__, __LINE__)

/**
 * @}
*/

#endif
