; TDFMacros.inc	BGLC includes for Terrain Data File Masks, Polygons, and Lines

; --------------------------------------------------------------------------------
; --------------------------------------------------------------------------------

VTPFileHeader		Macro	Version, IndexHeader, Textures, End

	LOCAL	start
start	LABEL	word

   DWORD 	20					;        		// Size of this header (20 bytes)
   DWORD 	Version					;          		// Version (must be 0x0100)
   SDWORD 	( OFFSET IndexHeader ) - ( OFFSET start )	;     		// Relative offset to index
   SDWORD 	( OFFSET Textures ) - ( OFFSET start )	;  	// Relative offset of the Texture List Header
   SDWORD 	( OFFSET End ) - ( OFFSET start )		;         		// Size of all data plus VTP headers

EndM

; --------------------------------------------------------------------------------


VTPIndexHeader		Macro	NumberIndexEntries, Index, Data

	LOCAL	start
start	Label 	word

   DWORD 	16					;       	// Size of this header (must be 16)
   DWORD 	NumberIndexEntries			;	// Number of entries in the index
   SDWORD 	( OFFSET Index ) - ( OFFSET start )		;       	// Relative offset to the index list
   SDWORD 	( OFFSET Data ) - ( OFFSET start )		;       	// Relative offset to the data

EndM



; --------------------------------------------------------------------------------

VTPIndexEntry		Macro	VTPCellID, start, Data, End

   VTPCellID 					;	// ID for cell
   SDWORD  	( OFFSET Data ) - ( OFFSET start )	;    	// Offset of data cell from VTPIndexHeader.lDataOffset
   SDWORD  	( OFFSET End ) - ( OFFSET Data )	;     	// Size of data cell

EndM

; --------------------------------------------------------------------------------

VTPCellID		Macro	Padding, U, V

;	DWORD m_dwPadding:12;		// Reserved, must be zero
;	DWORD m_dwU:10;	    		// The column (from 0 to 767) in the 768x512 world grid
;	DWORD m_dwV:10;	    		// The row (from 0 to 511)


	DWORD	( V * 400000h ) + ( U * 1000h ) + Padding

EndM

; --------------------------------------------------------------------------------

VTPTextureListHeader	Macro	NumberTextureEntries, Index, Data, End

	LOCAL	start
start	LABEL	WORD

   DWORD 	20				;       	// Size of this header (must be 20)
   DWORD 	NumberTextureEntries		;	// Number of entries in the index, (0 to 127)
   SDWORD 	( OFFSET Index ) - ( OFFSET start )	;       	// Relative offset to the index list
   SDWORD 	( OFFSET Data ) - ( OFFSET start )	;       	// Relative offset to the texture names
   DWORD 	( OFFSET End ) - ( OFFSET Data )	;      	// Total size of all the texture names

EndM

; --------------------------------------------------------------------------------

VTPTextureListEntry	Macro	Start, Data, End

	DWORD  ( OFFSET Data ) - ( OFFSET Start )		;	// Offset from the beginning of the name data
	DWORD  ( OFFSET End ) - ( OFFSET Data )		;	// Length of the filename in bytes including the terminating zero

EndM


; --------------------------------------------------------------------------------

VTPTextureName	Macro	Name

	BYTE	Name
	BYTE	0

EndM


; --------------------------------------------------------------------------------

VTPTextureType		Macro	Type, HasEffect, Reserved, Size

;	UINT8	uType:4		;	// Type of formatting used in the texture file
;	UINT8	fHasEffect:1	;	// Flag for determining if an effect will be used.
;	UINT8	uReserved	:3	;	// Unused, must be 0.
;	UINT8	uSize		;	// Meters per pixel of source texture.

	BYTE	( Reserved * 20h ) + ( HasEffect * 10h ) + Type
	BYTE	Size

EndM



; --------------------------------------------------------------------------------

VTPDataArea	Macro	LayerCount, AutoCalc, U, V

;	enum{ MaxLayerCount = 31 };
;	WORD wLayerCount:5;	// The number of layers in this area up to 31
;	WORD wAutoCalc:1;	// 0 = Method 1, 1 = Method 2
;	WORD wU:5;			// Column location relative to the cell
;	WORD wV:5;			// Row location relative to the cell

	WORD	( V * 800h ) + ( U * 40h ) + ( AutoCalc * 20h ) + LayerCount

EndM


; --------------------------------------------------------------------------------

VTPLayer		Macro	Layer, Replace

;	enum{ MaxLayer = 63 };
;	UINT8 bLayer:7;     // The layer ID, from 0 to 63.
;	UINT8 bReplace:1;   // 0 Coexist with existing data in the same layer   // 1 Replace all previous data in the same layer

	BYTE	( Replace * 80h ) + Layer

EndM


; --------------------------------------------------------------------------------

VTPNumTexturesInLayer	Macro	TextureCount, Reserved

;	enum{ MaxNumTextures = 127 };
;	UINT8 bTextureCount:7;		// From 0 to 127
;	UINT8 bReserved:1;   		// Reserved, must be 0

	BYTE	( Reserved * 80h ) + TextureCount

EndM


; --------------------------------------------------------------------------------

VTPTextureId	Macro	TextureID, Reserved

;	enum{ MaxTextureId = 127 };
;	UINT8 bTextureId:7;	// From 0 to 127.
;	UINT8 bReserved:1;	// Reserved, must be 0

	BYTE	( Reserved * 80h ) + TextureID


EndM

; --------------------------------------------------------------------------------

VTPPolyCount	Macro	Count, Reserved

;	enum{ MaxCount = 127 };
;	UINT8 bCount:7;		// From 0 to 127
;	UINT8 bReserved:1;	// Reserved, must be 0

	BYTE	( Reserved * 80h ) + Count

EndM

; --------------------------------------------------------------------------------

VTPPolyMethod1	Macro	PointCount, IsStrip, IsUVExplicit

;	enum{ MaxNumPoints = 62, PolyEx = MaxNumPoints+1 };
;	UINT8 bPointCount:6;		// Up to 62 points, 63 means that this is an 
;	  extended poly
;	UINT8 bIsStrip:1;			// 0 = Fan, 1 = Strip
;	UINT8 bIsUVExplicit:1;		// MUST BE 1 = Points contain XYUV


	BYTE	( IsUVExplicit * 80h ) + ( IsStrip * 40h ) + PointCount

EndM

; --------------------------------------------------------------------------------




VTPPolyMethod1Ex		Macro	ExPointCount

;	enum{ MaxNumPointsEx = 63 + 127 };
;	UINT8 bExPointCount; 	 // The number of points = 63 + bExPointCount


;	BYTE	ExPointCount
	WORD	ExPointCount

EndM



; --------------------------------------------------------------------------------


VTPPolyMethod2	Macro	PointCount, IsLine, Reserved

;	enum{ MaxNumPoints = 30, PolyEx2 = MaxNumPoints+1 };
;	UINT8 bPointCount:5;		// Up to 30 points, 31 means that this is an extended poly
;	UINT8 bIsLine:1;			// 0 = Fan, 1 = Line
;	UINT8 bReserved:2;         // reserved, must be 0

	BYTE	( Reserved * 40h ) + ( IsLine * 20h ) + PointCount

EndM

; --------------------------------------------------------------------------------

VTPPolyMethod2Ex		Macro	ExPointCount

;	enum{ MaxNumPointsEx = 31 + 127 };
;	UINT8 bExPointCount; 	 // The number of points = 31 + bExPointCount

;	BYTE	ExPointCount

	WORD	ExPointCount

EndM

; --------------------------------------------------------------------------------

VTPPointXYUV	Macro	X, Y, U, V

	BYTE	X	;	// The column offset in the area
	BYTE	Y	;	// The row offset in the area
	BYTE	U	;	// The column offset into the texture
	BYTE	V	;	// The row offset into the texture


EndM


; --------------------------------------------------------------------------------

VTPPointXY2	Macro	X, Y

	WORD	X	;	// The column offset in the area
	WORD	Y	;	// The row offset in the area

EndM


; --------------------------------------------------------------------------------

VTPWidePoint	Macro	X, UseWidth, Y, Reserved

;	DWORD uX:14;		  	// The column offset in the area
;	DWORD uUseWidth:1;  	// determines if a new width should be used  with this point
;	DWORD uY:14;	       	// The row offset in the area
;	DWORD uReserved:3;		// this is reserved and must be set to 0

	DWORD	( Reserved * 20000000h ) + ( Y * 8000h ) + ( UseWidth * 4000h ) + X

EndM

; --------------------------------------------------------------------------------

VTPWidePointWidth	Macro	Width
	
	BYTE	Width		;  // the width to use when rebuilding the vector data

EndM

; --------------------------------------------------------------------------------
; --------------------------------------------------------------------------------

LWMFileHeader		Macro	Version, IndexHeader, Data, End

	LOCAL	start
start	LABEL	word

    DWORD 	20					;           // Size of this header (20 bytes)
    DWORD 	Version					;            // Version (must be 0x0201)
    SDWORD 	( OFFSET IndexHeader ) - ( OFFSET start )	;	// Relative offset to index
    SDWORD 	( OFFSET Data ) - ( OFFSET start )		;            // Relative offset to data
    SDWORD 	( OFFSET End ) - ( OFFSET start )		;             // Size of all data plus headers

ENDM

; --------------------------------------------------------------------------------


LWMIndexHeader		Macro	NumberIndexEntries, Index

	LOCAL	start
start	Label 	word

    DWORD 	12				;             // Size of this header (12 bytes)
    DWORD 	NumberIndexEntries		;     // Number of entries in the index
    SDWORD 	( OFFSET Index ) - ( OFFSET start )	;             // Relative offset to the index data

ENDM
; --------------------------------------------------------------------------------


LWMIndexEntry		Macro	LWMCellID, start, Data, End

    LWMCellID 					;     // Location and default attributes or the cell
    SDWORD    ( OFFSET Data ) - ( OFFSET start )	;    // Offset from the beginning of the data block
    SDWORD    ( OFFSET End ) - ( OFFSET Data )		;      // Size of data block

EndM

; --------------------------------------------------------------------------------


LWMCellID		Macro	RunCount, IndexRun, Attrib, U, V

;    DWORD dwRunCount:9		; 	// Number of identical indices
;    DWORD dwIndexRun:1		; 	// If this 0 = single index, 1 = a series of indices
;    DWORD dwAttrib:2		;   	// The fill attribute 0 = water, 1 = land, 
;                       			; 	//    2 = flatten only, 3 = transparent
;    DWORD dwU:10			;       	// The column (from 0 to 767) in the 768x512 world grid
;    DWORD dwV:10			;       	// The row (from 0 to 511)

	DWORD	( V * 400000h ) + ( U * 1000h ) + ( Attrib * 400h ) + ( IndexRun * 200h ) + RunCount

EndM

; --------------------------------------------------------------------------------


LWMDataAreaFill1x1	Macro	Reserved, Attrib, Flag, Col, Row

;    WORD wReserved:3;        // Must be 0
;    WORD wAttrib:2;          // 0 = water, 1 = land, 2 = flatten
;    WORD wFlag:1;            // Must be 1
;    WORD wCol:5;             // Column (0-31)
;    WORD wRow:5;             // Row (0-31)

	WORD	( Row * 800h ) + ( Col * 40h ) + ( Flag * 20h ) + ( Attrib * 8h ) + Reserved

EndM

; --------------------------------------------------------------------------------


LWMDataAreaFill2x2	Macro	Reserved, Attrib, ZeroPad1, Flag, Col, ZeroPad2, Row

;    WORD wReserved:3;        // Must be 0
;    WORD wAttrib:2;          // 0 = water, 1 = land, 2 = flatten
;    WORD wZeroPad1:1;        // Must be 0
;    WORD wFlag:1;            // Must be 1
;    WORD wCol:4;             // Column (0-15)
;    WORD wZeroPad2:1;        // Must be 0
;   WORD wRow:4;             // Row (0-15)

	WORD	( Row * 1000h ) + ( ZeroPad2 * 800h ) + ( Col * 80h ) + ( Flag * 40h ) + ( ZeroPad1 * 20h ) + ( Attrib * 8h ) + Reserved
EndM

; --------------------------------------------------------------------------------


LWMDataAreaFill4x4	Macro	Reserved, Attrib, ZeroPad1, Flag, Col, ZeroPad2, Row

;    WORD wReserved:3;        // Must be 0
;    WORD wAttrib:2;          // 0 = water, 1 = land, 2 = flatten
;    WORD wZeroPad1:2;        // Must be 0
;    WORD wFlag:1;            // Must be 1
;    WORD wCol:3;             // Column (0-7)
;    WORD wZeroPad2:2;        // Must be 0
;    WORD wRow:3;             // Row (0-7)

	WORD	( Row * 2000h ) + ( ZeroPad2 * 800h ) + ( Col * 100h ) + ( Flag * 80h ) + ( ZeroPad1 * 20h ) + ( Attrib * 8h ) + Reserved
EndM

; --------------------------------------------------------------------------------


LWMDataAreaFill8x8	Macro	Reserved, Attrib, ZeroPad1, Flag, Col, ZeroPad2, Row

;    WORD wReserved:3;        // Must be 0
;    WORD wAttrib:2;          // 0 = water, 1 = land, 2 = flatten
;    WORD wZeroPad1:3;        // Must be 0
;    WORD wFlag:1;            // Must be 1
;    WORD wCol:2;             // Column (0-3)
;    WORD wZeroPad2:3;        // Must be 0
;    WORD wRow:2;             // Row (0-3)

	WORD	( Row * 4000h ) + ( ZeroPad2 * 800h ) + ( Col * 200h ) + ( Flag * 100h ) + ( ZeroPad1 * 20h ) + ( Attrib * 8h ) + Reserved

EndM

; --------------------------------------------------------------------------------


LWMDataAreaFill16x16	Macro	Reserved, Attrib, ZeroPad1, Flag, Col, ZeroPad2, Row

;    WORD wReserved:3;        // Must be 0
;    WORD wAttrib:2;          // 0 = water, 1 = land, 2 = flatten
;    WORD wZeroPad1:4;        // Must be 0
;    WORD wFlag:1;            // Must be 1
;    WORD wCol:1;             // Column (0-1)
;    WORD wZeroPad2:4;        // Must be 0
;    WORD wRow:1;             // Row (0-1)

	WORD	( Row * 8000h ) + ( ZeroPad2 * 800h ) + ( Col * 400h ) + ( Flag * 200h ) + ( ZeroPad1 * 20h ) + ( Attrib * 8h ) + Reserved

EndM

; --------------------------------------------------------------------------------


LWMDataAreaHeight	Macro	Height, Fraction

      SWORD Height		;	// integer height in meters   	-9999 is no height data!
      BYTE  Fraction	; 	// number of 1/128 meter fractions to add to Height    Zero if no height data!

EndM

; --------------------------------------------------------------------------------


LWMDataAreaDrawPolygons	Macro	PolyCount, Attrib, Flag, Col, Row

;    WORD wPolyCount:3		;  // The number of polygons up to 6. For 7 or more, use LWMDataAreaDrawPolygonsEx
;    WORD wAttrib:2		;     // Must be 3
;    WORD wFlag:1			;       // Must be 1!
;    WORD wCol:5			;        // Column, 0 to 31
;    WORD wRow:5			;        // Row, 0 to 31

	WORD	( Row * 800h ) + ( Col * 40h ) + ( Flag * 20h ) + ( Attrib * 8h ) + PolyCount

EndM

; --------------------------------------------------------------------------------


LWMDataAreaDrawPolygonsEx	Macro	PolyExFlag, Attrib, Flag, Col, Row, ExPolyCount

;    WORD wPolyExFlag:3		; // Must be 7.
;    WORD wAttrib:2		;     // Must be 3 (transparent)
;    WORD wFlag:1			;       // Must be 1!
;    WORD wCol:5			;        // Column, 0 to 31.
;    WORD wRow:5			;        // Row, 0 to 31.

	WORD	( Row * 800h ) + ( Col * 40h ) + ( Flag * 20h ) + ( Attrib * 8h ) + PolyExFlag
    	BYTE  ExPolyCount		;  // The number of polygons = 7 + ExPolyCount

EndM

; --------------------------------------------------------------------------------


LWMPoly2			Macro	PointCount, Reserved, Attrib, Height, Fraction

;    BYTE  bPointCount:6		;   // Up to 62 points
;    BYTE  bReserved:1		;     // Must be 0
;    BYTE  bAttrib:1		;       // Polygon fill attribute, 0 = water, 1 = land

	BYTE	( Attrib * 80h ) + ( Reserved * 40h ) + PointCount

	SWORD 	Height			;         // Whole elevation value in meters
	BYTE	Fraction			;       // Fractional elevation value in 1/128 meters

EndM

; --------------------------------------------------------------------------------


LWMPoly2Ex		Macro	PointCount, Reserved, Attrib, Height, Fraction, ExPointCount

;    BYTE  bPointCount:6		;   // Must be 63
;   BYTE  bReserved:1		;     // Must be 0
;    BYTE  bAttrib:1		;       // Polygon fill attribute, 0 = water, 1 = land

	BYTE	( Attrib * 80h ) + ( Reserved * 40h ) + PointCount

	SWORD	Height			     
	BYTE	Fraction			;      
	BYTE	ExPointCount		;   // Number of polygon points = 63 + bExPointCount

EndM

; --------------------------------------------------------------------------------


LWMPoint		Macro	x, y

  BYTE	x		;
  BYTE	y		;

EndM

; --------------------------------------------------------------------------------


LWMPoly1			Macro	PointCount, Reserved, Attrib

;    BYTE  bPointCount:6		;   // Up to 62 points
;    BYTE  bReserved:1		;     // Must be 0
;    BYTE  bAttrib:1		;       // Polygon fill attribute, 0 = water, 1 = land

	BYTE	( Attrib * 80h ) + ( Reserved * 40h ) + PointCount

EndM

; --------------------------------------------------------------------------------

