/*
 * Copyright (c) 2009, Yama
 * All rights reserved.
 * 
 * 
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 
 * 
 * \[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * oCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * ʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁA<gD>̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB 
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳ȂjڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 
 */

/*!
 @file PulseBoard.c
 @brief main֐LqN̓yыN̓łB
 @author RTi
 @date 9-jan-09, new
*/

/* SPLINT pDefine */
#ifdef S_SPLINT_S /* splint ғp */

/* RpCɐݒ肳define */
#ifndef __AVR_ATtiny2313__
#define __AVR_ATtiny2313__
#endif

#endif /* SPLINT pDefine */

#include <stdbool.h> /* true */
#include <stdlib.h> /* NULL malloc */
#include <errno.h> /* ERANGEgp邽߂ɕKv */
#include <ctype.h>
#include <avr/wdt.h>
#include <string.h> /* strtok */
#include "Modules.h"

/* [J֐ */
char * FuncKey(char * arg);
char * FuncVer(char * arg);
char * CommandCheck(char *buf);

/* R}hXg */

typedef struct {
	char Com; /* R}hLN^ */
	char* (*func)(char * arg); /* ߂lG[bZ[W 0:G[Ȃ*/
} CommList;

const CommList CList[] = {
	{(char)'V', FuncVer},	/* o[W\ */
	{(char)'K', FuncKey}	/* L[ */
};

#define BASE10 10 /* 10i@strtolp */

#define MAX_COMMAND_NUM (sizeof(CList)/sizeof(CommList))


typedef struct {
	uint8_t Key; /* 1~12 */
	bool On;	/* On:1 Off :0 */
} KeyStatus;

/*!
 @brief NyуC[v
 @return returnĂ͂Ȃ
*/
int main(void)
{
	(void)GetResetSetRegi(WDT_USE_1S);	/*!< Zbg擾 EHb`hbOgp */
	(void)hardwareInit();	/* n[hEFA@^[gp */
	InitUsart(); /* RXMobt@̏ */
	InitUsartLower(); /* RXMobt@[xw */ 
	ResetKey(); /* L[Ԃ̏ */

		
	//UART_write('\r'); /* sR[h */
	//UART_write('\n'); /* sR[h */
	SendText_P( PSTR(WAKEUP_MESSAGES)); /* NbZ[W */
	while(true)
	{
		/* WDTNA */
		wdt_reset();
		if(CheckCRLF() == true)
		{ /* R}h`FbN */
			(void)CommandCheck(GetBufPointer());
		}
	}
	/*@notreached@*/
	return 0;
}

char * CommandCheck(char *buf)
{
	char * err_msg;	/* G[bZ[W */
	uint8_t cnt; /* R}h`FbNJE^ */

	if( *buf != COMMAND_START_CHARACTER)
	{	/* R}h!n܂@łȂꍇ̓obt@ */
		err_msg = PSTR(ERROR_NOT_COMMAND);
		goto err;
	}
	/* R}h`FbN */
	/* 1.R}hLN^[ */
	buf++;
	if( isalpha(*buf) == 0)
	{
		err_msg = PSTR(ERROR_UNDEFINE_COMMAND);
		goto err;
	}
	/* R}hXgR}h`FbN */
	for(cnt = 0; cnt < MAX_COMMAND_NUM ; cnt++)
	{
		/* R}h1ł邱 */
		if( ( *buf == CList[cnt].Com ) && (( isspace(*(buf+1)) != 0) || (*(buf+1) == 0) ) )
		{
			err_msg = CList[cnt].func(buf);
			if( err_msg != NULL)
			{
				goto err;
			}
			InitUsart();
			break;
		}
	}
	return NULL;

err: /* G[ */
	InitUsart();
	SendText_P(err_msg);

	return err_msg;
}

/* arg = "K 1 1" -> L[1@ON */
/*     = "K 12 0" -> L[12@OFF */
char * FuncKey(char * arg)
{
	KeyStatus ks; /* L[Xe[^X@L[HON@Off@*/
	uint8_t on; /* ONOFF */
	char *next; /* strtolGh|C^ */
	char *sep; /* Zp[^ʒuۑ */

	arg++;
	/* p[^o */
	if( *arg != COMMAND_SEPARATER_CHARACTER)
		return PSTR(ERROR_SEPARATER); /* Zp[^[G[ */
	arg++;
	if( NULL == (sep = strchr(arg,COMMAND_SEPARATER_CHARACTER)))
		return PSTR(ERROR_SEPARATER); /* Zp[^[G[ */
	*sep = NULL;
	ks.Key = (uint8_t)strtol((const char*)arg, &next, BASE10); /* Pp[^ */
	if( arg == next )
		return PSTR(ERROR_KEY_PARAMETER); /* 1p[^G[ */
	if( ks.Key < MIN_KEY_NUM || ks.Key > MAX_KEY_NUM)
		return PSTR(ERROR_KEY_NUMBER); /* L[ԍG[ */
	
	arg = sep + 1;
	on = (uint8_t)strtol(arg, &next, BASE10); /* Qp[^ */
	if( arg == next )
		return PSTR(ERROR_ON_PARAMETER); /* 2p[^G[ */
	if( on < MIN_ON_NUM || on > MAX_ON_NUM)
		return PSTR(ERROR_ON_NUMBER); /* IԍG[ */
	ks.On = (( on == ON_PARA_INT_ON ) ?  ON_PARA_BOOL_ON : ON_PARA_BOOL_OFF );

	ChangeKeyStatus(ks.Key,ks.On);	
	
	SendText_P(PSTR(OK_KEY_SETTING));
	/*@notreached@*/
	return NULL;

}

char * FuncVer(char * arg)
{
	SendText_P(PSTR(VERSION_STRING));
	return NULL;
}
