/*
 * Copyright (c) 2009, Yama
 * All rights reserved.
 * 
 * 
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 
 * 
 * \[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * oCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * ʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁA<gD>̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB 
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳ȂjڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 
 */

/*!
 @file HardwareInit.c
 @brief n[hEFȀ܂
 @author RTi
 @date 7-jan-09, new
*/

/* SPLINT pDefine */
#ifdef S_SPLINT_S /* splint ғp */

/* RpCɐݒ肳define */
#ifndef __AVR_ATtiny2313__
#define __AVR_ATtiny2313__
#endif

#endif /* SPLINT pDefine */

#include <stdbool.h> /* true */
#include <ctype.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "Usart.h"

RxBuffer rbuf;

void InitUsart(void)
{
	rbuf.cdata[0] = '\0';
	rbuf.CRLF = false;
}


void InitUsartLower(void)
{
	rbuf.pos = 0;
	rbuf.data[0] = '\0';
}

/*!
 @brief s`FW荞 vector 12
*/
ISR(/*@unused@*/USART_RX_vect )
{
	uint8_t rdata;
	uint8_t cnt;

	rdata = UDR;
	if( ( UCSRA & (USART_FE_MASK | USART_DOR_MASK | USART_PE_MASK) ) != 0 )
	{ /* MG[ */
		return; /* Ȃɂ^[ */
	}
	if( ( isprint(rdata) != 0 ) ) /* \\ł */
	{
		rbuf.data[rbuf.pos] = rdata;
		rbuf.data[rbuf.pos + 1] = '\0';
		if(rbuf.pos < (sizeof(rbuf.data) - 2))
		{	/* obt@[̎c肪Qȏ̂Ƃ݈ʒu++@*/
			rbuf.pos++;
		}
	}
	else /* \\ȊÔƂ */
	{
		if(rdata == '\n')
		{	/* sM */
			rbuf.CRLF = true;
			
			for(cnt = 0; cnt < sizeof(rbuf.data); cnt++)
			{ /* Mf[^ޔ */
				rbuf.cdata[cnt] = rbuf.data[cnt];
				if(rbuf.cdata[cnt] == '\0' )
				{
					break;
				}
			}
			rbuf.pos = 0; /* obt@|WVNA */
			rbuf.data[0] = '\0'; /* Mobt@NA */
		}
	}
}

uint8_t CheckCRLF(void)
{
	return rbuf.CRLF;
}


char * GetBufPointer(void)
{
	return (char *)(rbuf.cdata);
}

void UART_write(char c)
{
	/*@ -whileempty @*/while( (UCSRA & USART_UDRE_MASK ) == 0);  /* M\ԂƂȂ܂őҋ@ */
	UDR = (uint8_t)c; 
}

void SendText_P(PGM_P buf) /* Program space */
{
	char c;
	while((c = pgm_read_byte(buf)) != (char)0)
	{
		UART_write(c);
		buf++;
	}
	
	UART_write('\r'); /* sR[h */
	UART_write('\n'); /* sR[h */
}
