<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Exception.class.php 70 2006-04-04 12:36:19Z sakamoto $
 */

/**
 * autoSOAPT[opO
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Exception extends Exception {
    private $soap_code;
    private $flg_logging = false;
    private $flg_request = false;

    /**
     * RXgN^
     * 
     * @access public 
     * @param string $message G[bZ[W
     * @param integer $code G[R[h
     * @param string $soap_code SOAPG[R[h
     * @param boolean $flg_logging Oc
     * @param boolean $flg_request OɃNCAg̃NGXgc
     * @param boolean $file G[t@CpX
     * @param boolean $line G[s
     * @return void 
     */
    public function __construct($message, $code, $soap_code, $flg_logging, $flg_request, $file = null, $line = null)
    {
        parent :: __construct($message, $code);

        $this->soap_code = $soap_code;
        $this->flg_logging = $flg_logging;
        $this->flg_request = $flg_request;

        if (!is_null($file))
            $this->file = $file;
        if (!is_null($line))
            $this->line = $line;
    } 

    /**
     * SOAPpR[hԂ
     * 
     * @access public 
     * @return string 'Client'  'Server'ԂĂ܂B
     */
    public function getSoapCode()
    {
        return $this->soap_code;
    } 

    /**
     * Ocǂ̃tOԂ
     * 
     * @access public 
     * @return boolean cꍇTRUEԂB
     */
    public function isLogging()
    {
        return (boolean)$this->flg_logging;
    } 

    /**
     * OɃNCAg̃NGXgcǂ̃tOԂ
     * 
     * @access public 
     * @return boolean cꍇTRUEԂB
     */
    public function is_saveRequest()
    {
        return (boolean)$this->flg_request;
    } 

    /**
     * G[o
     * 
     * @static 
     * @access public 
     * @param AutoSOAP_Exception $e G[i[ꂽGNXLvV
     * @param AutoSOAP_Service $service sT[rX
     * @param string $request NCAg̐NGXg
     */
    static public function output_error(AutoSOAP_Exception $e, AutoSOAP_Service $service, $logger, $request)
    {
        if (E_NOTICE == $e->getCode())
            return ;

        if ($e->isLogging()) {
            // Oo
            if ($logger instanceof AutoSOAP_Logger) {
                $tmp_req = ($e->is_saveRequest()) ? $request : null ;
                $logger->output($e, $service, $tmp_req);
            } 
        } 
        // SOAPG[bZ[Wo
        $matches = array();
        $err_mark = "";
        preg_match("/[^\/\\\]+$/", $e->getFile(), $matches);
        switch ($e->getCode()) {
        case E_ERROR : $err_mark = 'E_ERROR';
            break;
        case E_WARNING : $err_mark = 'E_WARNING';
            break;
        case E_PARSE : $err_mark = 'E_PARSE';
            break;
        case E_NOTICE : $err_mark = 'E_NOTICE';
            break;
        case E_CORE_ERROR : $err_mark = 'E_CORE_ERROR';
            break;
        case E_CORE_WARNING : $err_mark = 'E_CORE_WARNING';
            break;
        case E_COMPILE_ERROR : $err_mark = 'E_COMPILE_ERROR';
            break;
        case E_COMPILE_WARNING : $err_mark = 'E_COMPILE_WARNING';
            break;
        case E_USER_ERROR : $err_mark = 'E_USER_ERROR';
            break;
        case E_USER_WARNING : $err_mark = 'E_USER_WARNING';
            break;
        case E_USER_NOTICE : $err_mark = 'E_USER_NOTICE';
            break;
        } 
        $mssg = $err_mark . ' : ' . $e->getMessage() . '[' . $matches[0] . ':' . $e->getLine() . ']';

        $server = new SoapServer(null, array('soap_version' => SOAP_1_2,
                'uri' => "http://localhost/"
                ));
        $server->fault($e->getSoapCode(), $mssg);
    } 
} 

/**
 * SOAPNCAgO
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ClinetException extends AutoSOAP_Exception {
    /**
     * RXgN^
     * 
     * @access public 
     * @param string $message G[bZ[W
     * @param integer $code G[R[h
     * @param boolean $flg_logging Oc
     * @param boolean $flg_request OɃNCAg̃NGXgc
     * @param boolean $file G[t@CpX
     * @param boolean $line G[s
     * @return void 
     */
    public function __construct($message, $code, $flg_logging, $flg_request, $file = null, $line = null)
    {
        $soap_code = 'Client';
        parent :: __construct($message, $code, $soap_code, $flg_logging, $flg_request, $file, $line);
    } 
} 

/**
 * SOAPT[oO
 * 
 * @package jp.servlet.AutoSOAP.server.exception
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ServerException extends AutoSOAP_Exception {
    /**
     * RXgN^
     * 
     * @access public 
     * @param string $message G[bZ[W
     * @param integer $code G[R[h
     * @param boolean $flg_logging Oc
     * @param boolean $flg_request OɃNCAg̃NGXgc
     * @param boolean $file G[t@CpX
     * @param boolean $line G[s
     * @return void 
     */
    public function __construct($message, $code, $flg_logging, $flg_request, $file = null, $line = null)
    {
        $soap_code = 'Server';
        parent :: __construct($message, $code, $soap_code, $flg_logging, $flg_request, $file, $line);
    } 
} 

?>