<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: ReflectionAccept.php 68 2006-04-01 14:27:55Z sakamoto $
 */

/**
 * AutoSOAP_ReflectionAccept C^[tF[X
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
interface AutoSOAP_ReflectionAccept {
    /**
     * AutoSOAP_ReflectionVisitor󂯓(Visitorp^[)
     * 
     * @param AutoSOAP_ReflectionVisitor $visitor
     */
    public function accept(AutoSOAP_ReflectionVisitor $visitor);
} 

/**
 * ReflectorAcceptɑ΂ďs܂B
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ReflectionAcceptImpl implements AutoSOAP_ReflectionAccept, Reflector
{
    private $_reflection;
    private $_visit_method;

    /**
     * RXgN^
     * 
     * @final 
     * @param Reflector $reflection 
     */
    final public function __construct(Reflector $reflection)
    {
        $this->_reflection = $reflection;
        if ($reflection instanceof ReflectionParameter) {
            $this->_visit_method = "visitParameter";
        } else if ($reflection instanceof ReflectionMethod) {
            $this->_visit_method = "visitMethod";
        } else if ($reflection instanceof ReflectionObject) {
            $this->_visit_method = "visitObject";
        } else if ($reflection instanceof ReflectionProperty) {
            $this->_visit_method = "visitProperty";
        } else if ($reflection instanceof ReflectionExtension) {
            $this->_visit_method = "visitExtension";
        } else if ($reflection instanceof ReflectionFunction) {
            $this->_visit_method = "visitFunction";
        } else if ($reflection instanceof ReflectionClass) {
            $this->_visit_method = "visitClass";
        } else {
            $this->_visit_method = "";
        } 
    } 

    /**
     * GNX|[g
     * 
     * @static 
     * @param mixed $obj 
     */
    static public function export($obj)
    {
        return $this->_reflection->export($obj);
    } 

    /**
     * __toString
     */
    public function __toString()
    {
        return $this->_reflection->__toString();
    } 

    /**
     * AutoSOAP_ReflectionVisitor󂯓(Visitorp^[)
     * 
     * @final 
     * @param AutoSOAP_ReflectionVisitor $visitor
     */
    final public function accept(AutoSOAP_ReflectionVisitor $visitor)
    {
        $method = $this->_visit_method;
        return $visitor->$method($this);
    } 

    /**
     * tNV̌^Ԃ
     * 
     * @final 
     */
    final public function getReflectionType()
    {
        return get_class($this->_reflection);
    } 

    /**
     * ReflectorpNXׂĂAutoSOAP_ReflectionAccept֕ϊ
     * 
     * @final 
     * @param mixed $target 
     */
    final private function &convertAutoSOAP_ReflectionAcceptImpl($target)
    {
        if (is_array($target)) {
            $tmp = new AutoSOAP_ReflectionChildren();
            foreach($target as $index => &$val) {
                if (is_object($val)) {
                    $tmp->add($this->convertAutoSOAP_ReflectionAcceptImpl($val), $index);
                } else {
                    $tmp->add($val, $index);
                } 
            } 
            return $tmp;
        } else if ($target instanceof Reflector) {
            $tmp = new AutoSOAP_ReflectionAcceptImpl($target);
            return $tmp;
        } 
        return $target;
    } 

    /**
     * vpeB̐ݒReflectorɔC
     * 
     * @final 
     * @param mixed $propety vpeB
     * @param mixed $value l
     */
    final public function __set($propety, $value)
    {
        $this->_reflection->$propety = $value;
    } 
    /**
     * vpeB̎擾ReflectorɔC
     * 
     * @final 
     * @param mixed $propety vpeB
     */
    final public function __get($propety)
    {
        return $this->_reflection->$propety;
    } 
    /**
     * \bh̏ReflectorɔC
     * 
     * @final 
     * @param mixed $method ֐
     * @param mixed $args ̔z
     */
    final public function __call($method, $args)
    {
        $result = call_user_func_array(array($this->_reflection, $method), $args);
        return $this->convertAutoSOAP_ReflectionAcceptImpl($result);
    } 
} 

/**
 * AutoSOAP_ReflectionChildren
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ReflectionChildren implements AutoSOAP_ReflectionAccept {
    private $_children = array();

    /**
     * AutoSOAP_ReflectionVisitor󂯓(Visitorp^[)
     * 
     * @final 
     * @param AutoSOAP_ReflectionVisitor $visitor
     */
    final public function accept(AutoSOAP_ReflectionVisitor $visitor)
    {
        return $visitor->visitChildren($this);
    } 

    /**
     * q̒ǉ
     * 
     * @final 
     * @param AutoSOAP_ReflectionAcceptImpl $child
     * @param integer $index 
     */
    final public function add(AutoSOAP_ReflectionAcceptImpl $child, $index = -1)
    {
        $count = count($this->_children);
        if (is_numeric($index) && -1 < $index && $count > $index) {
            if (0 == $index) {
                array_unshift($this->_children, $child);
            } else {
                for($i = $count-1;$i >= $index;$i--) {
                    $this->_children[$index + 1] = $this->_children[$index];
                } 
                $this->_children[$index] = $child;
            } 
        } else if ('' == $index) {
            $this->_children[] = $child;
        } else if (is_string($index)) {
            $this->_children[$index] = $child;
        } else {
            $this->_children[] = $child;
        } 
        return $child;
    } 

    /**
     * C^[^Ԃ
     * 
     * @final 
     */
    final public function getIterator()
    {
        $tmp = new ArrayObject($this->_children);
        return $tmp->getIterator();
    } 
} 

/**
 * AutoSOAP_ReflectionAcceptɑ΂ďs܂B
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
interface AutoSOAP_ReflectionVisitor {
    /**
     * ʂԂ
     */
    public function getResult();
    /**
     * NX
     * 
     * @param AutoSOAP_ReflectionAccept $class
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class);
    /**
     * vpeB
     * 
     * @param AutoSOAP_ReflectionAccept $property
     */
    public function visitProperty(AutoSOAP_ReflectionAccept $property);
    /**
     * \bh
     * 
     * @param AutoSOAP_ReflectionAccept $method
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method);
    /**
     * ֐
     * 
     * @param AutoSOAP_ReflectionAccept $func
     */
    public function visitFunction(AutoSOAP_ReflectionAccept $func);
    /**
     * 
     * 
     * @param AutoSOAP_ReflectionAccept $param
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param);
    /**
     * IuWFNg
     * 
     * @param AutoSOAP_ReflectionAccept $object
     */
    public function visitObject(AutoSOAP_ReflectionAccept $object);
    /**
     * GNXeV
     * 
     * @param AutoSOAP_ReflectionAccept $extension
     */
    public function visitExtension(AutoSOAP_ReflectionAccept $extension);
    /**
     * q
     * 
     * @param AutoSOAP_ReflectionChildren $children
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children);
} 

?>