/**
 * Created on 30 Oct. 2009
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2009 HIMACS,Ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */
/**
 * To avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
package jp.himacs.avoidbugs.ipv6.bug6230761;

import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

/**
 * @author t-tsue
 *
 */
public class IPv6AddressBean {
	private int port;
	private byte[] host = new byte[16];
	private int scopeId;
	public byte[] getHost() {
		return host;
	}
	public void setHost(byte[] host) {
		this.host = host;
	}
	public int getPort() {
		return port;
	}
	public void setPort(int port) {
		this.port = port;
	}
	public int getScopeId() {
		return scopeId;
	}
	public void setScopeId(int scopeId) {
		this.scopeId = scopeId;
	}
	
	public InetSocketAddress getSocketAddress() throws UnknownHostException {
		Inet6Address i6addr = Inet6Address.getByAddress(null, host, scopeId);
		InetSocketAddress addr = new InetSocketAddress(i6addr, port);
		return addr;
	}
}
