/**
 * Created on 30 Oct. 2009
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2009 HIMACS,Ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */
/**
 * To avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
package jp.himacs.avoidbugs.ipv6.bug6230761;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelectionKey;

/**
 * @author t-tsue
 * to avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
public class SelectionKeyIPv6 extends AbstractSelectionKey implements Comparable {
	/**
	 * channel instance.
	 */
	private AbstractSelectableChannel channel;
	
	/**
	 * selector instance.
	 */
	private SelectorIPv6 selector;

	/**
	 * interest options.
	 */
	private int interestOpts = 0;
	
	/**
	 * ready options.
	 */
	protected int readyOpts = 0;
	
	/**
	 * constructor.
	 * @param selector selector
	 */
	public SelectionKeyIPv6(SelectorIPv6 selector,AbstractSelectableChannel channel) {
		this.selector = selector;
		this.channel = channel;
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.SelectionKey#channel()
	 */
	@Override
	public SelectableChannel channel() {
		return channel;
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.SelectionKey#interestOps()
	 */
	@Override
	public int interestOps() {
		return interestOpts;
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.SelectionKey#interestOps(int)
	 */
	@Override
	public SelectionKey interestOps(int opts) {
		interestOpts = opts;
		return this;
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.SelectionKey#readyOps()
	 */
	@Override
	public int readyOps() {
		return readyOpts;
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.SelectionKey#selector()
	 */
	@Override
	public Selector selector() {
		return selector;
	}

	public int compareTo(Object arg0) {
		return 1;
	}
}
