/**
 * Created on 30 Oct. 2009
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2009 HIMACS,Ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */
/**
 * To avoid the follwing bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
package jp.himacs.avoidbugs.ipv6.bug6230761;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

/**
 * @author t-tsue
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6230761
 */
public class SelectorProviderImplIPv6 extends SelectorProvider {

	/* (non-Javadoc)
	 * @see java.nio.channels.spi.SelectorProvider#openDatagramChannel()
	 */
	@Override
	public DatagramChannel openDatagramChannel() throws IOException {
		return new DatagramChannelImplIPv6(this);
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.spi.SelectorProvider#openPipe()
	 */
	@Override
	public Pipe openPipe() throws IOException {
		throw new IOException("Not implemented");
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.spi.SelectorProvider#openSelector()
	 */
	@Override
	public AbstractSelector openSelector() throws IOException {
		return new SelectorIPv6(this);
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.spi.SelectorProvider#openServerSocketChannel()
	 */
	@Override
	public ServerSocketChannel openServerSocketChannel() throws IOException {
		throw new IOException("Not implemented");
	}

	/* (non-Javadoc)
	 * @see java.nio.channels.spi.SelectorProvider#openSocketChannel()
	 */
	@Override
	public SocketChannel openSocketChannel() throws IOException {
		throw new IOException("Not implemented");
	}

}
