/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.regex.Pattern;
import plus.util.Escape;

public final class Term {
    public static final NUMBER NUMBER_ZERO = new NUMBER("0", 0);

    private Term() {
    }

    public static class NUMBER
    extends YyValue {
        private static final Pattern RX_INTEGER_NUMBER = Pattern.compile("^[-+]?\\d+$");

        public NUMBER(String x, Number e) {
            super(x, NUMBER.getType(x, e), e);
        }

        private static int getType(String x, Number e) {
            if (!RX_INTEGER_NUMBER.matcher(x).matches()) {
                return 257;
            }
            if (0.0 == e.doubleValue() - (double)e.intValue()) {
                return 33;
            }
            if (0.0 == e.doubleValue() - (double)e.longValue()) {
                return 65;
            }
            return 257;
        }

        public final double doubleValue() {
            return ((Number)this.value).doubleValue();
        }

        public final String toString() {
            return this.id;
        }
    }

    public static class YyValue {
        public final String id;
        public final int nType;
        public final Object value;

        YyValue(String x, int typ, Object val) {
            this.id = x;
            this.nType = typ;
            this.value = val;
        }
    }

    public static class STRING
    extends YyValue {
        public STRING(String x) {
            super(x, 2, x);
        }

        public final String toString() {
            return "'" + Escape.encodeString(this.id, "\\'") + "'";
        }
    }

    public static class REGEXP
    extends YyValue {
        public REGEXP(String x) {
            super(x, 18, Escape.encodeString(x, "\""));
        }

        public final String toString() {
            return "/" + Escape.nopFilter(this.id) + "/";
        }
    }

    public static class BOXING
    extends YyValue {
        public BOXING(String x) {
            super(x, 31, x);
        }

        public final String toString() {
            return this.id;
        }
    }
}

