/*
 * Decompiled with CFR 0.152.
 */
package plus.runtime;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UnknownFormatConversionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import plus.io.Command;
import plus.io.IoHelper;
import plus.io.TextReader;
import plus.runtime.BuiltInVar;
import plus.runtime.RegExp;
import plus.spawn.system.UtilInterface;
import plus.util.NumHelper;

public final class RunHelper {
    private static final int CSTAT_ABEND_CODE = 128;
    private static final int CSTAT_CNCEL_CODE = 129;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final boolean IS_WINDOWS = "\r\n".equals(System.getProperty("line.separator"));
    private static final int REGX_GRP2_ARGUMENTINDEX = 2;
    private static final int REGX_GRP3_FLAGS = 3;
    private static final int REGX_GRP4_CONVERSION = 4;
    private static final Pattern RX_SPRINTF_EXPONENTIAL = Pattern.compile("(.+e[-+])(\\d+)$");
    private static final Pattern RX_SPRINTF_FORMAT = Pattern.compile("(%%)|%(?:(\\d*)\\$)?([^a-zA-Z]*)([a-zA-Z])");
    private static final Pattern RX_SPRINTF_G = Pattern.compile("\\.?0+$");
    private static final Pattern RX_SPRINTF_ZTERMINATE_DECIMAL = Pattern.compile("\\d\\.\\d*0+$");
    private static final Pattern RX_SYSTEM_SPLIT = Pattern.compile("\\s+");

    public static String concat(CharSequence sep, CharSequence convfmt, Object[] args) {
        CharSequence fmt = null == convfmt ? BuiltInVar.CONVFMT.toString() : convfmt;
        StringBuilder sb = new StringBuilder();
        for (Object x : args) {
            sb.append(RunHelper.toString(fmt, x)).append(sep);
        }
        sb.setLength(sb.length() - sep.length());
        return sb.toString();
    }

    @Nullable
    public static synchronized String getlineImpl(TextReader reader) throws IOException {
        String rs = BuiltInVar.RS.toString();
        String line = reader.readLine(rs);
        if (null != line) {
            BuiltInVar.RT.put(reader.getRT());
        }
        return line;
    }

    public static int indexOf(CharSequence s, CharSequence t) {
        String x = RunHelper.toString(null, s);
        String y = Objects.toString(t, "");
        int ignoreCase = BuiltInVar.IGNORECASE.intValue();
        return 1 + (0 == ignoreCase ? x.indexOf(y) : x.toLowerCase().indexOf(y.toLowerCase()));
    }

    public static int length(Object s) {
        int len = 0;
        if (s instanceof Object[]) {
            len = ((Object[])s).length;
        } else if (s instanceof Map) {
            len = ((Map)s).size();
        } else if (s instanceof CharSequence) {
            len = ((CharSequence)s).length();
        } else if (s instanceof Number) {
            len = RunHelper.toString(null, s).length();
        } else if (s instanceof List) {
            len = ((List)s).size() - 1;
        } else if (s instanceof Collection) {
            len = ((Collection)s).size();
        } else if (s instanceof Iterator) {
            Iterator x = (Iterator)s;
            while (x.hasNext()) {
                ++len;
                x.next();
            }
        } else if (s instanceof Enumeration) {
            Enumeration x = (Enumeration)s;
            while (x.hasMoreElements()) {
                ++len;
                x.nextElement();
            }
        } else if (null != s) {
            len = s.toString().length();
        }
        return len;
    }

    public static String replaceNL2ORS(String x, String ors) {
        return x.replaceAll("\r\n|\r|\n", ors);
    }

    public static int sleep(double second) {
        if (!Thread.currentThread().isInterrupted()) {
            double seconds = second * 1000.0;
            long millis = (long)seconds;
            int nanos = (int)((seconds - (double)millis) * 1000000.0);
            try {
                if (0 == nanos) {
                    Thread.sleep(millis);
                } else {
                    Thread.sleep(millis, nanos);
                }
                return 0;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return 1;
    }

    public static int split(String s, Map<String, Object> a, String ... r) {
        String fs = 0 == r.length ? null : r[0];
        a.clear();
        String[] arr = RunHelper.split2Array(s, fs);
        int len = arr.length;
        for (int i = 0; len > i; ++i) {
            a.put(Integer.toString(i + 1), NumHelper.toStringNumber(arr[i]));
        }
        return len;
    }

    public static String[] split2Array(String s, String f) {
        if (null != s && 0 < ((String)s).length()) {
            String fs = f;
            if (f == null) {
                fs = BuiltInVar.FS.toString();
                if (" ".equals(fs)) {
                    fs = "\\s+";
                    s = ((String)s).trim();
                }
            } else if (fs.isEmpty()) {
                int i = ((String)s).length();
                String[] arr = new String[i];
                while (0 <= --i) {
                    arr[i] = Character.toString(((String)s).charAt(i));
                }
                return arr;
            }
            String guard = "\u0000\u0001\u0002\u0003";
            s = (String)s + guard;
            String fx = 1 < fs.length() ? fs : (0 <= "[]\\".indexOf(fs.charAt(0)) ? "[\\" + fs + "]" : "[" + fs + "]");
            Matcher m = RegExp.compile(fx).matcher((CharSequence)s);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (m.find(i)) {
                list.add(((String)s).subSequence(i, m.start()).toString());
                i = m.end();
            }
            if (i < ((String)s).length()) {
                list.add(((String)s).subSequence(i, ((String)s).length()).toString());
            } else {
                list.add("");
            }
            for (i = list.size() - 1; i >= 0; --i) {
                String x = (String)list.get(i);
                if (!x.isEmpty()) {
                    if (!x.endsWith(guard)) break;
                    if ((x = x.substring(0, x.length() - guard.length())).isEmpty()) {
                        list.remove(i);
                        break;
                    }
                    list.set(i, x);
                    break;
                }
                list.remove(i);
            }
            return list.toArray(new String[0]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public static String sprintf(Object ... args) {
        int aglen = args.length;
        if (0 != aglen) {
            StringBuilder sb = new StringBuilder();
            String convfmt = null;
            String fmt = args[0].toString();
            Matcher m = RX_SPRINTF_FORMAT.matcher(fmt);
            int sp = 0;
            int i = 0;
            while (m.find()) {
                sb.append(fmt, sp, m.start());
                if (null != m.group(1)) {
                    sb.append('%');
                } else {
                    int ix = null == m.group(2) ? ++i : NumHelper.intValue(m.group(2));
                    String x = 0 < ix && aglen > ix ? args[ix] : "";
                    String fm = "%" + m.group(3) + m.group(4);
                    char f = Character.toLowerCase(m.group(4).charAt(0));
                    try {
                        String ss;
                        if (0 <= "aefgdox".indexOf(f)) {
                            double dd = NumHelper.doubleValue(x);
                            if (0 <= "dox".indexOf(f)) {
                                ss = String.format(fm, (long)dd);
                            } else {
                                Matcher me;
                                Object ww = String.format(fm, dd);
                                if (IS_WINDOWS && 0 <= "efg".indexOf(f) && (me = RX_SPRINTF_EXPONENTIAL.matcher((CharSequence)ww)).find()) {
                                    ww = me.group(1) + "0" + me.group(2);
                                }
                                if ('g' == f && RX_SPRINTF_ZTERMINATE_DECIMAL.matcher((CharSequence)ww).find()) {
                                    ww = RX_SPRINTF_G.matcher((CharSequence)ww).replaceFirst("");
                                }
                                ss = ww;
                            }
                        } else if (0 <= "cs".indexOf(f)) {
                            if (null == convfmt) {
                                convfmt = BuiltInVar.CONVFMT.toString();
                            }
                            ss = String.format(fm, RunHelper.toString(convfmt, x));
                        } else {
                            ss = String.format(fm, x);
                        }
                        sb.append(ss);
                    }
                    catch (UnknownFormatConversionException e) {
                        System.err.println("INFO: sprintf('" + m.group() + "','" + x + "')");
                        throw e;
                    }
                }
                sp = m.end();
            }
            if (sp < fmt.length()) {
                sb.append(fmt.substring(sp));
            }
            return sb.toString();
        }
        return "";
    }

    public static String strftime(String fmt, long timestamp) {
        Date x = new Date(timestamp);
        try {
            return new SimpleDateFormat(fmt).format(x);
        }
        catch (IllegalArgumentException e) {
            return x.toString();
        }
    }

    public static String substr(CharSequence s, int i, int n) {
        int len = s.length();
        int idx = 0 >= i ? 0 : (len < i ? len : i - 1);
        int wid = 0 >= n ? 0 : Math.min(len, idx + n) - idx;
        return 0 > len - wid - idx ? "" : s.subSequence(idx, idx + wid).toString();
    }

    public static int system(String command) {
        String cmd = command.trim();
        if (cmd.isEmpty()) {
            System.out.flush();
            System.err.flush();
            return 0;
        }
        String[] arr = RX_SYSTEM_SPLIT.split(cmd);
        if ("exit".equals(arr[0])) {
            return 1 >= arr.length ? 0 : NumHelper.intValue(arr[1]);
        }
        if ("sleep".equals(arr[0])) {
            if (1 < arr.length) {
                return RunHelper.sleep(NumHelper.doubleValue(arr[1]));
            }
            return 0;
        }
        int rc = 128;
        try {
            UtilInterface out = (UtilInterface)((Object)Command.processWriter(cmd));
            if (out.hasInput()) {
                IoHelper.copyline("/dev/stdin", (Writer)((Object)out));
            }
            out.close();
            rc = out.exitValue();
        }
        catch (InterruptedIOException e) {
            System.err.println("system: " + e + ": `" + cmd + "`");
            rc = 129;
        }
        catch (IOException e) {
            System.err.println("system: " + e + ": `" + cmd + "`");
            e.printStackTrace();
        }
        return rc;
    }

    public static String toString(CharSequence convfmt, Object x) {
        if (x instanceof String) {
            return (String)x;
        }
        if (x instanceof Number) {
            Number num = NumHelper.normalise((Number)x);
            if (num instanceof Integer || num instanceof Long) {
                return num.toString();
            }
            CharSequence fmt = null == convfmt ? BuiltInVar.CONVFMT.toString() : convfmt;
            return RunHelper.sprintf(fmt, x);
        }
        if (x instanceof Boolean) {
            return (Boolean)x != false ? "1" : "0";
        }
        return null == x ? "" : x.toString();
    }
}

