/*
 * Copyright (C) 2010 awk4j - http://awk4j.sourceforge.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.io;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

/**
 * [%interface%] I/O Interface.
 * <p>
 * The class to which this annotation is applied is immutable.
 *
 * @author kunio himei.
 */
final class IoConstants {

    /**
     * UTF-8 8 bit UCS Transformation Format.
     */
    static final String CHARSET_UTF8_NAME = StandardCharsets.UTF_8.name();

    /**
     * この環境のデフォルトの文字セット.
     */
    static final String CHARSET_DEFAULT_NAME = Charset.defaultCharset().name();

    /**
     * 入力ｽﾄﾘｰﾑのバッファサイズ.
     */
    static final int DEFAULT_BYTE_BUFFER_SIZE = 1024 * 8;

    /**
     * 入力ｽﾄﾘｰﾑの文字バッファサイズ (DEFAULT_BYTE_BUFFER_SIZE / 2).
     */
    static final int DEFAULT_CHAR_BUFFER_SIZE = 1024 * 4;

    /**
     * この環境(プラットフォーム)の行セパレータ.
     */
    static final String PLATFORM_LINE_SEPARATOR = System
            .getProperty("line.separator");

    /**
     * [%URL%] FILE スキーム名.
     */
    static final String SCHEME_URL_FILE = "file";

    /**
     * [%URL%] INET URL を識別する. [file://]/inet/...[#Charset]
     */
    static final Pattern START_WITH_INET_URL = Pattern.compile("^("
            + SCHEME_URL_FILE + "://)?/inet/");

    /**
     * Don't let anyone instantiate this class.
     */
    private IoConstants() {
        super();
    }
}