/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import plus.io.IoConstants;
import plus.io.NullInputStream;
import plus.io.NullOutputStream;
import plus.io.StreamWriter;
import plus.io.TextReader;

public final class Device {
    private static final String PREFIX_HTTP_URL = "http:";
    private static final String PREFIX_HTTPS_URL = "https:";

    private Device() {
    }

    static String getCharset(String name, char ... mode) {
        String charset;
        String string = charset = name.contains("://") && 0 <= name.indexOf(35) ? name.replaceFirst("^.*#", "") : "";
        if (charset.isEmpty()) {
            if (0 < mode.length) {
                return IoConstants.CHARSET_DEFAULT_NAME;
            }
            return IoConstants.CHARSET_UTF8_NAME;
        }
        return charset;
    }

    private static String getPath(String name) {
        return name.contains("://") ? name.replaceAll("^(file:///)|(#[-\\w]+)$", "") : name;
    }

    public static Reader openInput(String name) throws IOException {
        if ("/dev/stdin".equals(name) || "-".equals(name)) {
            return new TextReader(System.in);
        }
        if ("/dev/null".equals(name)) {
            return new TextReader(NullInputStream.THIS);
        }
        if (name.startsWith(PREFIX_HTTP_URL)) {
            URL url = new URL(name);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTP responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(name, new char[0]));
        }
        if (name.startsWith(PREFIX_HTTPS_URL)) {
            URL url = new URL(name);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTPS responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(name, new char[0]));
        }
        String path = Device.getPath(name);
        if (!new File(path).exists()) {
            throw new FileNotFoundException("'" + path + "'");
        }
        FileInputStream in = new FileInputStream(path);
        return new InputStreamReader((InputStream)in, Device.getCharset(name, 'r'));
    }

    public static Writer openOutput(String rid, String name) throws IOException {
        if ("/dev/stdout".equals(name) || "-".equals(name)) {
            return new StreamWriter(System.out);
        }
        if ("/dev/stderr".equals(name)) {
            return new StreamWriter(System.err);
        }
        if ("/dev/null".equals(name)) {
            return new StreamWriter(NullOutputStream.THIS);
        }
        String path = Device.getPath(name);
        FileOutputStream out = Device.openOutputStreamImpl(rid, path);
        return new StreamWriter(out, Device.getCharset(name, 'w'));
    }

    private static FileOutputStream openOutputStreamImpl(String rid, String name) throws IOException {
        boolean append;
        File file = new File(name);
        File dir = file.getParentFile();
        if (null != dir && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("mkdirs: " + String.valueOf(dir));
        }
        boolean bl = append = !file.createNewFile();
        if (">".equals(rid)) {
            return new FileOutputStream(file);
        }
        return new FileOutputStream(file, append);
    }
}

