/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

final class PipedWriter
extends Writer {
    static final char[] ENPTY_CHAR_ARRAY = new char[0];
    private static final int INITIAL_INPUT_BUFFERSIZE = 4096;
    private static final long WAIT_TIME = 10L;
    private final LinkedBlockingQueue<char[]> queue = new LinkedBlockingQueue();
    private final Reader reader = new Tr();
    private volatile boolean hasClose;
    private volatile int inputBufferSize = 4096;

    PipedWriter() {
    }

    @Override
    public void close() {
        this.hasClose = true;
    }

    @Override
    public void flush() {
    }

    public Reader getReader() {
        return this.reader;
    }

    char[] readBuffer(int maxlength) throws InterruptedIOException {
        if (maxlength > this.inputBufferSize) {
            this.inputBufferSize = maxlength;
        }
        char[] arr = this.queue.poll();
        while (!this.hasClose && null == arr) {
            try {
                arr = this.queue.poll(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                this.hasClose = true;
                Thread.currentThread().interrupt();
                throw new InterruptedIOException(e.getMessage());
            }
        }
        return arr;
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) {
        int x;
        if (cbuf == null) {
            PipedWriter.$$$reportNull$$$0(0);
        }
        int xoff = off;
        for (int xlen = len; 0 < xlen; xlen -= x) {
            x = Math.min(this.inputBufferSize, xlen);
            char[] arr = new char[x];
            System.arraycopy(cbuf, xoff, arr, 0, x);
            this.queue.offer(arr);
            xoff += x;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "plus/io/PipedWriter", "write"));
    }

    final class Tr
    extends Reader {
        private char[] buffer = ENPTY_CHAR_ARRAY;

        Tr() {
        }

        @Override
        public void close() {
        }

        @Override
        public synchronized int read(@NotNull char[] cbuf, int off, int len) throws InterruptedIOException {
            if (cbuf == null) {
                Tr.$$$reportNull$$$0(0);
            }
            char[] buf = this.buffer;
            while (null != buf && 0 == buf.length) {
                buf = PipedWriter.this.readBuffer(len);
            }
            if (null != buf) {
                char[] arr;
                int xlen = buf.length;
                int x = Math.min(xlen, len);
                System.arraycopy(buf, 0, cbuf, off, x);
                if (0 < (xlen -= x)) {
                    arr = new char[xlen];
                    System.arraycopy(buf, x, arr, 0, xlen);
                } else {
                    arr = ENPTY_CHAR_ARRAY;
                }
                this.buffer = arr;
                return x;
            }
            this.buffer = null;
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cbuf", "plus/io/PipedWriter$Tr", "read"));
        }
    }
}

