/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus.run

import groovy.transform.CompileStatic
import plus.reflect.Listener
import plus.reflect.Reflection

/**
 * AWK~plus - Function Value.
 *
 * @author kunio himei.
 */
@CompileStatic
class Function extends Listener {

    private Object obj
    private String name
    private Object[] args

    Function(Object obj, String name, Object[] args) {
        this.obj = obj
        this.name = name
        this.args = args
    }

    //* このオブジェクトに引数を適用する.
    // パラメータが省略された場合は、初期化時に指定された値を使用.
    Object apply(Object[] a) {
        Object[] arr = (0 == a.length) ? this.args : a
        return Reflection.invoke(obj, name, arr)
    }

    Object call() { return apply(this.args) }

    //* このオブジェクトの simple name を返す.
    String getName() { return this.name.replaceFirst(/^.*[$]/, "") }

    //* このオブジェクトの full name を返す.
    String toString() { return this.name }
}