/*
 * Decompiled with CFR 0.152.
 */
package plus.concurrent;

import java.util.regex.Pattern;
import plus.BiAccessor;
import plus.concurrent.FutureMap;
import plus.reflect.Reflection;
import plus.runtime.BuiltInVar;
import plus.util.NumHelper;

public final class Argument
extends FutureMap<Integer, Object> {
    public static final String USAGE = "AWK~Plus [Script] [Options] [Args]\nOptions:\n  -F val\t\u30d5\u30a3\u30fc\u30eb\u30c9\u30bb\u30d1\u30ec\u30fc\u30bf\u3001\u521d\u671f\u5024\u306f\u7a7a\u767d\u3068\u30bf\u30d6\n  -v var = val\t\u5b9f\u884c\u524d\u306b\u5909\u6570\u5024\u3092\u4ee3\u5165\n  var = val\t\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u3067\u6307\u5b9a\u3057\u305f\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u6642\u306b\u4ee3\u5165\n";
    private static final String[][] ARGV_OPTS = new String[][]{{"-D", "D"}, {"-F", "F"}, {"--field-separator=", "F"}, {"-v", "v"}, {"--assign=", "v"}};
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private static final Pattern rxASSIGN_PAT = Pattern.compile("^[A-Za-z_$][\\w$]+[\\s]*=");
    private final Object owner;

    public Argument(String[] args, Object owner) {
        super(args.length);
        this.owner = owner;
        this.parse(args);
        BuiltInVar.ARGC.put(super.size());
        BuiltInVar.ARGIND.put(0);
        BuiltInVar.FILENAME.put("");
    }

    private static String[] splitVar(String var) {
        int i = var.indexOf(61);
        String name = var.substring(0, i).trim();
        String value = var.substring(i + 1);
        return new String[]{name, value};
    }

    private static void setProperty(String var) {
        String[] a = Argument.splitVar(var);
        System.setProperty(a[0], a[1]);
    }

    private void invoke(String var) {
        String[] a = Argument.splitVar(var);
        Object name = a[0];
        Object value = NumHelper.toStringNumber(a[1]);
        if ("FS".equals(name) && a[1].isEmpty()) {
            value = " ";
        }
        System.err.println("`invoke: " + (String)name + "=" + (value instanceof String ? "'" + value + "'" : value));
        BuiltInVar x = BuiltInVar.forName((String)name);
        if (null != x) {
            x.put(value);
        } else if (Reflection.has(this.owner, (String)name, ONE_OBJECT_ARRAY)) {
            name = "set" + ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
            Reflection.invoke(this.owner, (String)name, new Object[]{value});
        } else {
            BiAccessor._GLOBALS((String)name, value);
        }
    }

    private void append(String x) {
        super.putAt((Object)super.size(), NumHelper.toStringNumber(x));
    }

    private void parse(String[] args) {
        this.append("-");
        boolean hasOptions = true;
        int len = args.length;
        for (int idx = 0; len > idx; ++idx) {
            String arg = args[idx];
            if (arg.isEmpty() || "''".equals(arg) || "\"\"".equals(arg)) {
                this.append("");
                continue;
            }
            if ('-' == arg.charAt(0)) {
                StringBuilder sb = new StringBuilder(arg);
                if (hasOptions) {
                    if ("--".equals(arg)) {
                        hasOptions = false;
                        continue;
                    }
                    for (String[] argopt : ARGV_OPTS) {
                        int p;
                        String opt = argopt[0];
                        for (p = 1; p < opt.length() && p < sb.length() && opt.charAt(p) == sb.charAt(p); ++p) {
                        }
                        if ('-' == opt.charAt(p - 1)) continue;
                        char optchr = argopt[1].charAt(0);
                        while (p < sb.length() && Character.isWhitespace(sb.charAt(p))) {
                            ++p;
                        }
                        if (sb.length() <= p && idx + 1 < args.length && '-' != args[idx + 1].charAt(0)) {
                            sb.append(args[idx + 1]);
                            ++idx;
                        }
                        String val = sb.substring(p);
                        if ('F' == optchr) {
                            this.invoke("FS=" + val);
                        } else if ('v' == optchr) {
                            this.invoke(val);
                        } else if ('D' == optchr) {
                            Argument.setProperty(val);
                        }
                        sb.setLength(0);
                        break;
                    }
                }
                if (0 >= sb.length()) continue;
                this.append(arg);
                continue;
            }
            if (rxASSIGN_PAT.matcher(arg).find()) {
                this.append(arg);
                continue;
            }
            this.append(arg);
        }
    }

    public Object next() {
        int argc = BuiltInVar.ARGC.intValue();
        int i = BuiltInVar.ARGIND.intValue();
        Object x = "";
        while (argc > ++i) {
            x = super.getAt(i);
            String file = x.toString();
            if (file.isEmpty()) continue;
            if (!rxASSIGN_PAT.matcher(file).find()) break;
            this.invoke(file);
            x = "";
        }
        BuiltInVar.ARGIND.put(i);
        BuiltInVar.FILENAME.put(x);
        return x;
    }

    @Override
    public Integer arrayKey(Object index) {
        if (index instanceof Number) {
            return ((Number)index).intValue();
        }
        return NumHelper.intValue(index);
    }
}

