/*
 * Decompiled with CFR 0.152.
 */
package plus.runtime;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import plus.concurrent.ArrayAccessor;
import plus.concurrent.AtomicNumber;
import plus.concurrent.FutureMap;
import plus.concurrent.Record;
import plus.runtime.RunHelper;
import plus.util.NumHelper;

public enum BuiltInVar implements ArrayAccessor<Object, Object>
{
    _$(new Record()),
    $(new Record()),
    ENVIRON(new FutureMap<K, V>()),
    ARGV(new Record()),
    ARGC,
    ARGIND,
    CONVFMT("%.6g"),
    ERRNO(""),
    FIELDWIDTHS(""),
    FILENAME(""),
    FNR,
    FS(" "),
    IGNORECASE,
    NF,
    NR,
    OFMT("%.6g"),
    OFS(" "),
    ORS("\n"),
    PROCINFO(new FutureMap<K, V>()),
    RESULT(""),
    RLENGTH,
    RS("\n"),
    RSTART,
    RT(""),
    SUBSEP("\u001c");

    private static final Map<String, BuiltInVar> REVERCE_MAP;
    private static final int NumberType = 0;
    private static final int StringType = 1;
    private static final int ObjectType = 2;
    private static final int ArrayType = 3;
    private final int type;
    private final boolean enableAlias;
    private final AtomicNumber atom = new AtomicNumber();
    private transient ArrayAccessor<Object, Object> arr;
    private volatile Object obj;

    private BuiltInVar() {
        this.enableAlias = true;
        this.type = 0;
    }

    private BuiltInVar(ArrayAccessor<Object, Object> x) {
        this.enableAlias = false;
        this.type = 3;
        this.arr = x;
    }

    private BuiltInVar(Object x) {
        this.enableAlias = true;
        this.type = x instanceof String ? 1 : 2;
        this.obj = x;
    }

    @Nullable
    public static BuiltInVar forName(String name) {
        return REVERCE_MAP.get(name);
    }

    public static String getAlias(String name) {
        BuiltInVar var = BuiltInVar.forName(name);
        if (null != var) {
            if ("$".equals(name)) {
                return _$.name();
            }
            if (var.enableAlias) {
                return "$" + name;
            }
        }
        return name;
    }

    public Object get() {
        return switch (this.type) {
            case 0 -> this.atom.intValue();
            case 3 -> this.arr;
            default -> this.obj;
        };
    }

    public void put(Object value) {
        switch (this.type) {
            case 0: {
                this.atom.setAtom(NumHelper.doubleValue(value));
                break;
            }
            case 1: {
                this.obj = RunHelper.toString(null, value);
                break;
            }
            case 3: {
                this.arr = (ArrayAccessor)value;
            }
            default: {
                this.obj = value;
            }
        }
    }

    public Object calculate(String op, Object right) {
        if (this.type == 0) {
            return this.atom.calculate(op, right);
        }
        this.put(right);
        return right;
    }

    @Override
    public Object getAt(Object index) {
        if (null != index) {
            return this.arr.getAt(index);
        }
        return this.get();
    }

    @Override
    public void putAt(Object index, Object value) {
        if (null != index) {
            this.arr.putAt(index, value);
        } else {
            this.put(value);
        }
    }

    public int intValue() {
        return this.atom.intValue();
    }

    public String toString() {
        return this.get().toString();
    }

    static {
        REVERCE_MAP = new HashMap<String, BuiltInVar>(BuiltInVar.values().length);
        for (BuiltInVar x : BuiltInVar.values()) {
            REVERCE_MAP.put(x.name(), x);
        }
        for (Map.Entry entry : System.getenv().entrySet()) {
            ENVIRON.putAt(entry.getKey(), ((String)entry.getValue()).replace('\\', '/'));
        }
        BuiltInVar._$.arr = BuiltInVar.$.arr;
    }
}

