/** AWK~plus - Image Viewer (Groovy).
 */
# package sample
import java.awt.Point
import java.awt.event.*
import javax.swing.*
import plus.awt.Mouse
import plus.reflect.Reflection
    val imageLabel = new JLabel("", SwingConstants.CENTER)
    val frame = new JFrame("AWK~plus - ImageViewer (Groovy)")
    val DELAY_SECONDS = 10  # 表示間隔
    val FRAME_HEIGHT = 600  # 画像サイズ
    val FRAME_WIDTH = 400
    var imgnumber = 0
    var images = ""
    var imgpos = -1
BEGIN {
    images = ARGV[1]  # 画像のパス
    imgnumber = ARGV[2]  # 画像の枚数
    frame.setDefaultCloseOperation(3)
    val dim = frame.getToolkit().getScreenSize()
    frame.setLocation(new Point(
      # 演算結果が、Doubleになるためキャストする.(Since the operation result will be Double, cast it.)
        int(dim.width - 8 - FRAME_WIDTH), int(dim.height - 32 - FRAME_HEIGHT)))
    val container = frame.getContentPane()
        container.add(imageLabel)
    val adapter = new Mouse(.mouseDragged(null), .mousePressed(null))
        container.addMouseListener(adapter); container.addMouseMotionListener(adapter)
    actionPerformed(null)
    frame.pack()
    frame.setVisible(true)
    val actionListener: ActionListener =
        Reflection.implement("java.awt.event.ActionListener", .actionPerformed(null))
    new Timer(1000 * DELAY_SECONDS, actionListener).start()
}
function actionPerformed(actionEvent) {
    imgpos = ++imgpos % imgnumber
    imageLabel.setIcon(new ImageIcon(images "/" imgpos ".jpg"))
}
function mouseDragged(e: MouseEvent) {
    val opacity = 0.01 * (100 - abs(e.getY()) % 100)
    frame.setOpacity(opacity)  # Java8 No longer supported
}
function mousePressed(e: MouseEvent) {  # Right button click
    if (1 != e.getButton()) frame.setAlwaysOnTop(!frame.isAlwaysOnTop())
}