/*
 * Decompiled with CFR 0.152.
 */
package plus.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import plus.reflect.Cache;
import plus.reflect.Listener;
import plus.reflect.RefHelper;
import plus.runtime.RegExp;
import plus.util.NumHelper;

public final class Reflection {
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static Class<?> classForName(Object obj) {
        Class<?> x;
        String name = obj.toString();
        Class<?> clazz = x = obj instanceof Class ? (Class)obj : Cache.CLASS.get(name);
        if (null == x) {
            try {
                x = Class.forName(name.isEmpty() ? "''" : name);
                Cache.CLASS.put(name, x);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        return x;
    }

    private static Class<?> getClassOf(Object obj) {
        return null == obj ? Object.class : (obj instanceof Class ? (Class<?>)obj : obj.getClass());
    }

    public static boolean has(Object obj, String name, Object[] args) {
        if (null != obj) {
            int arglen = args.length;
            if (0 == arglen && ("length".equals(name) && (obj instanceof Object[] || obj instanceof CharSequence || obj instanceof Class && (((Class)obj).isArray() || String.class == obj)) || "size".equals(name) && (obj instanceof Map || obj instanceof Collection))) {
                return true;
            }
            Class<?> clazz = Reflection.getClassOf(obj);
            return 0 != RefHelper.getMethods(clazz, name, arglen).length || null != RefHelper.getField(clazz, name);
        }
        return false;
    }

    public static boolean hasClass(String name) {
        if (null == name || name.isEmpty()) {
            return false;
        }
        Class<?> x = (Class<?>)Cache.CLASS.get(name);
        if (null == x) {
            try {
                x = Class.forName(name);
                Cache.CLASS.put(name, x);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasField(String obj, String name) {
        return 1 == Reflection.hasMethodImpl(obj, name, 0);
    }

    public static boolean hasMethod(String obj, String name, int argslen) {
        return 2 == Reflection.hasMethodImpl(obj, name, argslen);
    }

    private static int hasMethodImpl(String obj, String name, int argslen) {
        if (Reflection.hasClass(obj)) {
            Class<?> clazz = Reflection.classForName(obj);
            if (0 != RefHelper.getMethods(clazz, name, argslen).length) {
                return 2;
            }
            return 0 == argslen && null != RefHelper.getField(clazz, name) ? 1 : 0;
        }
        return -1;
    }

    public static Object imple(Class<?>[] interfaces, Listener[] listeners) {
        return Reflection.mixin(null, interfaces, listeners);
    }

    public static <E> E implement(Object interfac, Listener listener) {
        Class[] clazz = new Class[]{Reflection.classForName(interfac)};
        Listener[] objs = new Listener[]{listener};
        return (E)Reflection.mixin(null, clazz, objs);
    }

    private static Object invoke(Class<?> clazz, Object obj, String name, Object[] args) {
        Object[] argTypes = Reflection.toClass(args);
        Method method = null;
        Field x = (Field)Cache.FIELD.get(RefHelper.getFieldKey(clazz, name));
        if (null == x && null == (method = RefHelper.getMethod(clazz, name, args, argTypes))) {
            x = RefHelper.getField(clazz, name);
        }
        try {
            if (null != method) {
                return method.invoke(obj, RefHelper.cast(method.getParameterTypes(), argTypes, args));
            }
            if (null != x) {
                x.setAccessible(true);
                if (0 != args.length) {
                    Object o = RefHelper.cast(x.getType(), argTypes[0], args[0]);
                    x.set(obj, o);
                    return o;
                }
                return x.get(obj);
            }
            throw new IllegalArgumentException(RefHelper.mkString("NoSuchMethodException: " + clazz.getName() + "." + name, args));
        }
        catch (Exception e) {
            RefHelper.info("invoke: " + (null == method ? clazz.getName() + "." + name : method));
            RefHelper.info(RefHelper.mkString("args: ", args));
            RefHelper.info(RefHelper.mkString("type: ", argTypes));
            throw new IllegalArgumentException(Reflection.unwrap(e));
        }
    }

    public static Object invoke(Object obj, String name, Object[] args) {
        Class<?> clazz;
        int arglen = args.length;
        if (0 == arglen) {
            if ("length".equals(name)) {
                if (obj instanceof Object[]) {
                    return ((Object[])obj).length;
                }
                if (obj instanceof CharSequence) {
                    return ((CharSequence)obj).length();
                }
            } else if ("size".equals(name)) {
                if (obj instanceof Map) {
                    return ((Map)obj).size();
                }
                if (obj instanceof Collection) {
                    return ((Collection)obj).size();
                }
            } else if ("toString".equals(name)) {
                return obj.toString();
            }
        }
        if (Pattern.class == (clazz = Reflection.getClassOf(obj)) && "compile".equals(name)) {
            assert (0 != arglen);
            int flg = 1 < arglen ? NumHelper.intValue(args[1]) : 0;
            String r = args[0].toString();
            return RegExp.compile(r, flg);
        }
        return Reflection.invoke(clazz, obj, name, args);
    }

    public static Object mixin(final Object obj, Class<?>[] interfaces, final Listener[] listeners) {
        return Proxy.newProxyInstance(Reflection.class.getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) {
                Object[] argv = null == args ? EMPTY_OBJECT_ARRAY : args;
                String name = method.getName();
                for (Listener x : listeners) {
                    if (!name.equals(x.getName())) continue;
                    return x.apply(argv);
                }
                if (null != obj) {
                    return Reflection.invoke(obj, name, argv);
                }
                return null;
            }
        });
    }

    public static Object newInstance(String obj, Object[] args) {
        Object[] argTypes;
        Class<?> clazz = Reflection.classForName(obj);
        Constructor<?> x = RefHelper.getConstructor(clazz, args, argTypes = Reflection.toClass(args));
        if (null == x) {
            throw new IllegalArgumentException(RefHelper.mkString("NoSuchConstructorException: " + clazz.getName(), args));
        }
        try {
            return 0 == args.length ? x.newInstance(new Object[0]) : x.newInstance(RefHelper.cast(x.getParameterTypes(), argTypes, args));
        }
        catch (Exception e) {
            RefHelper.info("new: " + clazz.getName());
            RefHelper.info(RefHelper.mkString("args: ", args));
            RefHelper.info(RefHelper.mkString("type: ", argTypes));
            throw new RuntimeException(Reflection.unwrap(e));
        }
    }

    private static Class<?>[] toClass(Object[] args) {
        int i = args.length;
        Class[] arr = new Class[i];
        while (0 <= --i) {
            arr[i] = Reflection.getClassOf(args[i]);
        }
        return arr;
    }

    private static Throwable unwrap(Throwable e) {
        Throwable ex = e;
        while (null != ex.getCause()) {
            ex = ex.getCause();
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return ex;
    }
}

