/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.awk4j.space.Main;

public class Parser {
    private static final char C_UTF_BOM = '\ufffe';
    private static final String S_UTF_BOM = String.valueOf('\ufffe');
    public static final char C_DELETE = '\u2714';
    private static final char NL = '\n';
    private final StringBuilder buffer = new StringBuilder(512);
    public String debug;
    public int cutSpace;
    private int indentLength;
    private boolean isPre;
    private static final Pattern INDENT = Pattern.compile("^(\\s*)");
    private static final Pattern HTML_EXTRACT_TAG = Pattern.compile("(\\s*)(<(/?)([a-zA-Z]+[1-6]?)[^<>]*(>?))(\\s*)");
    private static final List<String> HTML_BLOCK_ELEMENT_LIST = Arrays.asList("address", "article", "aside", "blockquote", "br", "dd", "details", "dialog", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hgroup", "hr", "li", "main", "nav", "ol", "pre", "p", "section", "table", "td", "th", "tr", "title", "ul");
    private static final Set<String> HTML_BLOCK_ELEMENT_SET = new HashSet<String>(HTML_BLOCK_ELEMENT_LIST);

    public String parse(String input) {
        Matcher m = INDENT.matcher(input);
        this.indentLength = m.find() ? m.end(1) : 0;
        String result = this.space(this.join(input));
        this.debug = result.replace('\ufffe', '\u2714');
        String output = result.replace(S_UTF_BOM, "");
        this.cutSpace += result.length() - output.length();
        return output;
    }

    private String join(String input) {
        this.buffer.setLength(0);
        this.buffer.append(input);
        Matcher m = HTML_EXTRACT_TAG.matcher(this.buffer);
        while (m.find()) {
            boolean hasEnd;
            String tagName = Parser.getBlockElement(m.group(4));
            if (tagName.isEmpty() || (hasEnd = !Parser.getValue(m.group(5)).isEmpty())) continue;
            String in = Main.getLine();
            if (in == null) break;
            this.buffer.append(' ').append(in.trim());
            System.out.println(Main.lineNumber + ": " + m.group(2));
            m.reset(this.buffer);
        }
        return this.buffer.toString();
    }

    private String space(String input) {
        this.buffer.setLength(0);
        Matcher m = HTML_EXTRACT_TAG.matcher(input);
        while (m.find()) {
            Object replacement;
            String tagName = Parser.getBlockElement(m.group(4));
            if (!tagName.isEmpty()) {
                int ix;
                boolean hasIndent;
                String left = Parser.getValue(m.group(1));
                String right = Parser.getValue(m.group(6));
                boolean bl = hasIndent = this.indentLength == m.end(1);
                if (Main.isDebug) {
                    System.out.println(Main.lineNumber + ": " + hasIndent + "\t" + m.end(1) + "\t'" + m.group() + "'");
                }
                if (tagName.equals("pre")) {
                    this.isPre = Parser.getValue(m.group(3)).isEmpty();
                    if (this.isPre && !hasIndent && !left.isEmpty()) {
                        left = S_UTF_BOM;
                    }
                }
                if (!this.isPre) {
                    if (!hasIndent && !left.isEmpty()) {
                        left = S_UTF_BOM;
                    }
                    if (!right.isEmpty()) {
                        right = S_UTF_BOM;
                    }
                }
                if ((ix = this.buffer.length()) > 0 && this.buffer.charAt(ix - 1) == ' ') {
                    Parser.rTrim(this.buffer).append('\ufffe');
                    if (S_UTF_BOM.equals(left)) {
                        left = "";
                    }
                }
                replacement = left + m.group(2) + right;
            } else {
                replacement = m.group();
            }
            m.appendReplacement(this.buffer, (String)replacement);
        }
        m.appendTail(this.buffer);
        return this.buffer.append('\n').toString();
    }

    private static String getBlockElement(String tag) {
        String tagName = tag.toLowerCase();
        if (HTML_BLOCK_ELEMENT_SET.contains(tagName)) {
            return tagName;
        }
        return "";
    }

    public static String rTrim(String s) {
        int length;
        int end = length = s.length();
        while (0 <= --end && ' ' >= s.charAt(end)) {
        }
        return ++end < length ? s.substring(0, end) : s;
    }

    public static StringBuilder rTrim(StringBuilder s) {
        int length;
        int end = length = s.length();
        while (0 <= --end && ' ' >= s.charAt(end)) {
        }
        if (++end < length) {
            s.setLength(end);
        }
        return s;
    }

    private static String getValue(String val) {
        return val == null ? "" : val;
    }
}

