/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.asm;

import org.awk4j.bench.Bench;
import org.awk4j.bench.target.Trim;

public class AsmFuture {
    private static final trim03Original<String, String> trim03Original = new trim03Original();
    private static final trim04String<String, String> trim04String = new trim04String();
    private static final trim05CharSeq<CharSequence, String> trim05CharSeq = new trim05CharSeq();
    private static long loop_time;

    static <T> int driver01Generics(Future<T, String> fnc, String ans) {
        String rs;
        long start;
        long nano = loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = fnc.apply(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (ans.equals(rs)) : rs;
        return count;
    }

    static void crew(int[] ANSWER, long time) {
        loop_time = time;
        ANSWER[2] = AsmFuture.driver01Generics(trim03Original, "^^);");
        ANSWER[3] = AsmFuture.driver01Generics(trim04String, "^^);");
        ANSWER[4] = AsmFuture.driver01Generics(trim05CharSeq, "^^);");
    }

    static <T> T as(Object o) {
        return (T)o;
    }

    static abstract class Future<T, R> {
        Future() {
        }

        abstract R apply(T var1);
    }

    private static class trim03Original<T, R>
    extends Future<String, String> {
        private trim03Original() {
        }

        @Override
        public String apply(String t) {
            return t.trim();
        }
    }

    private static class trim04String<T, R>
    extends Future<String, String> {
        private trim04String() {
        }

        @Override
        public String apply(String t) {
            return Trim.trim04String(t);
        }
    }

    private static class trim05CharSeq<T, R>
    extends Future<CharSequence, String> {
        private trim05CharSeq() {
        }

        @Override
        public String apply(CharSequence t) {
            return Trim.trim05CharSeq(t);
        }
    }
}

