/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import plus.runtime.RegExp;

public final class TextReader
extends BufferedReader {
    private static final String CRLF_SEPARATOR = "\r\n";
    private static final int DEFAULT_STRING_BUILDERSIZE = 509;
    private static final int EOF = -1;
    private static final char EOL = '\n';
    private static final int REGX_DEFALUT_CAPACITY = 4096;
    private static final int REGX_MAX_CAPACITY = 0x100000;
    private final boolean isCloseable;
    private final StringBuilder line = new StringBuilder(509);
    private int capacity = 4096;
    private boolean isClosed;
    private String recTerm = "";

    public TextReader(InputStream input) {
        super(new InputStreamReader(input));
        this.isCloseable = false;
    }

    public TextReader(Reader input) {
        super(input, 8192);
        this.isCloseable = true;
    }

    private int charAt(int index) throws IOException {
        while (this.line.length() <= index && !this.isClosed) {
            this.getBuffer();
        }
        return 0 <= index && this.line.length() > index ? (int)this.line.charAt(index) : -1;
    }

    @Override
    public void close() throws IOException {
        if (this.isCloseable) {
            this.isClosed = true;
            super.close();
        }
    }

    private void getBuffer() throws IOException {
        if (!this.isClosed) {
            String lin = null;
            try {
                lin = super.readLine();
                if (null != lin) {
                    this.line.append(lin);
                    this.line.append('\n');
                }
            }
            finally {
                if (null == lin || Thread.currentThread().isInterrupted()) {
                    this.close();
                }
            }
        }
    }

    public String getRT() {
        return this.recTerm;
    }

    private boolean hasNext() throws IOException {
        if (!this.isClosed && 0 == this.line.length()) {
            this.getBuffer();
        }
        return 0 < this.line.length();
    }

    private int indexOf(String str, int index) throws IOException {
        int ix;
        while (0 > (ix = this.line.indexOf(str, index)) && !this.isClosed) {
            this.getBuffer();
        }
        return ix;
    }

    @Nullable
    public String readLine(String rs) throws IOException {
        boolean isCRLFRS = CRLF_SEPARATOR.equals(rs);
        String rsep = isCRLFRS ? Character.toString('\n') : rs;
        boolean isNewlineRS = "\n".equals(rsep);
        if (this.hasNext()) {
            int eol;
            int last;
            int end;
            boolean isEmptyRS = rsep.isEmpty();
            int start = 0;
            if (isCRLFRS || isNewlineRS || isEmptyRS) {
                if (isEmptyRS) {
                    end = this.indexOf("\n\n", start = this.skipNL(start));
                    if (0 <= end) {
                        eol = last = this.skipNL(end + 2);
                    } else {
                        for (eol = last = this.line.length(); start < eol && 10 == this.charAt(eol - 1); --eol) {
                        }
                        end = eol;
                    }
                } else {
                    end = this.indexOf(rsep, start);
                    if (0 <= end) {
                        eol = last = end + rsep.length();
                    } else {
                        last = end = this.line.length();
                        eol = end;
                    }
                }
            } else {
                Pattern pattern = RegExp.compile(rsep);
                while (true) {
                    if (this.line.length() < this.capacity && !this.isClosed) {
                        this.getBuffer();
                        continue;
                    }
                    eol = last = this.line.length();
                    end = last;
                    Matcher re = pattern.matcher(this.line);
                    if (re.find()) {
                        end = re.start();
                        eol = last = re.end();
                        if ('^' != rsep.charAt(0)) break;
                        while (!this.isClosed) {
                            this.getBuffer();
                        }
                        break;
                    }
                    if (0x100000 > this.capacity) break;
                    this.capacity <<= 1;
                    if (this.isClosed) break;
                }
            }
            this.recTerm = this.line.substring(end, eol);
            if (0 < this.line.length() && start < last) {
                String ws = this.line.substring(start, end);
                this.line.delete(0, last);
                return ws;
            }
            this.line.setLength(0);
        }
        return null;
    }

    private int skipNL(int index) throws IOException {
        int i = index;
        while (10 == this.charAt(i)) {
            ++i;
        }
        return i;
    }
}

