/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import net.morilib.awk.parser.AwkToken;

public class AwkSyntaxException extends AwkCompilationException {

	//
	private AwkToken expected, but;
	private String variable;

	/**
	 * 
	 * @param lineno
	 * @param expected
	 * @param but
	 */
	public AwkSyntaxException(int lineno, AwkToken expected,
			AwkToken but) {
		super(lineno, "expected " + expected + " but " + but);
		this.expected = expected;
		this.but = but;
	}

	/**
	 * 
	 * @param lineno
	 * @param variable
	 * @param but
	 */
	public AwkSyntaxException(int lineno, String variable,
			AwkToken but) {
		super(lineno, "expected <" + variable + "> but " + but);
		this.variable = variable;
		this.but = but;
	}

	/**
	 * 
	 * @param lineno
	 * @param mesg
	 */
	public AwkSyntaxException(int lineno, String mesg) {
		super(lineno, mesg);
	}

	/**
	 * 
	 * @return
	 */
	public AwkToken getExpected() {
		return expected;
	}

	/**
	 * 
	 * @return
	 */
	public AwkToken getBut() {
		return but;
	}

	/**
	 * 
	 * @return
	 */
	public String getVariable() {
		return variable;
	}

}
