/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class AwkNegater extends AwkExpression {

	private AwkExpression e1;

	public AwkNegater(AwkExpression e1) {
		this.e1 = e1;
	}

	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue v;

		v = e1.eval(ns, o);
		if(v.isInteger()) {
			return AwkInteger.valueOf(v.toInteger().negate());
		} else if(v.isFloat()) {
			return AwkFloat.valueOf(-v.toFloat());
		} else {
			throw new AwkCastException("number required");
		}
	}

	public boolean isLvalue() {
		return false;
	}

}
