/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.mat;

import net.morilib.awk.builtin.AwkBinaryArgs;
import net.morilib.awk.builtin.mat.AwkMatrices;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class MatMultiply
extends AwkBinaryArgs {
    protected MatMultiply() {
        super("multiply");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2) {
        String sep = ns.getRoot().find("SUBSEP").toString(ns);
        if (!a1.isArray()) {
            return AwkUndefined.UNDEF;
        }
        DoubleMatrix a = AwkMatrices.toDoubleMatrix(a1, sep);
        if (a == null) {
            return AwkUndefined.UNDEF;
        }
        DoubleMatrix b = AwkMatrices.toDoubleMatrix(a2, sep);
        if (b != null) {
            DoubleMatrix c = b.mul(a);
            return AwkMatrices.toAwkArray(c, sep);
        }
        DoubleVector v = AwkMatrices.toDoubleVector(a2);
        DoubleVector w = a.mul(v);
        return AwkMatrices.toAwkArray(w);
    }
}

