/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.builtin.stat;

import java.util.Arrays;
import net.morilib.awk.builtin.AwkQuaternaryArgs;
import net.morilib.awk.builtin.stat.AwkStatisticsException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class Histogram
extends AwkQuaternaryArgs {
    public Histogram() {
        super("histogram");
    }

    public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1, AwkValue a2, AwkValue a3, AwkValue a4) {
        AwkArray ar = new AwkArray();
        double min = a2.toFloat();
        double max = a3.toFloat();
        double stp = a4.toFloat();
        if (min >= max) {
            throw new AwkStatisticsException("Illegal range");
        }
        if (stp <= 0.0) {
            throw new AwkStatisticsException("Illegal step");
        }
        if ((max - min) / stp + 2.0 > 2.147483647E9) {
            throw new AwkStatisticsException("Too much bins");
        }
        long[] bin = new long[(int)Math.ceil((max - min) / stp) + 2];
        Arrays.fill(bin, 0L);
        for (AwkValue v : a1.values()) {
            double d;
            if (!v.isRealValue()) continue;
            double x = v.toFloat();
            if (d < min) {
                bin[0] = bin[0] + 1L;
                continue;
            }
            if (x > max) {
                int n = bin.length - 1;
                bin[n] = bin[n] + 1L;
                continue;
            }
            int n = (int)((x - min) / stp) + 1;
            bin[n] = bin[n] + 1L;
        }
        int i = 0;
        while (i < bin.length) {
            ar.putArray(String.valueOf(i), AwkInteger.valueOf(bin[i]));
            ++i;
        }
        return ar;
    }
}

