/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.morilib.awk.Awk;
import net.morilib.awk.AwkCompilationException;
import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.gui.CharsetComboBox;
import net.morilib.awk.misc.NullWriter;
import net.morilib.unix.glob.WildcardFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwkFrame
extends JFrame {
    private static final String DEF = "default";
    private static final String CH1 = "1 character";
    private static final String REG = "regular expression";
    private JTextField t1 = new JTextField(50);
    private JTextArea t2 = new JTextArea();
    private JComboBox c3 = new JComboBox();
    private JFileChooser f1 = new JFileChooser();
    private JCheckBox c1 = new JCheckBox("apply for subfolders");
    private JComboBox c4 = new JComboBox();
    private JTextField t3 = new JTextField(25);
    private JMenuBar mb = new JMenuBar();
    private JFileChooser f2 = new JFileChooser("open a script");
    private JFileChooser f3 = new JFileChooser("save the script");
    private CharsetComboBox cs1 = new CharsetComboBox();
    private CharsetComboBox cs2 = new CharsetComboBox();
    private File script;
    private AwkImmediate immediate = new AwkImmediate();

    boolean addfs(List<File> fs, File f, boolean dir) {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File g = fileArray[n2];
                if (g.isFile() || g.isDirectory() && dir) {
                    fs.add(g);
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    void warnbox(String s) {
        JOptionPane.showMessageDialog(this, s, "awkium", 2);
    }

    void errbox(String s) {
        JOptionPane.showMessageDialog(this, s, "awkium", 0);
    }

    void infobox(String ... ss) {
        StringBuffer b = new StringBuffer();
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            b.append(s).append('\n');
            ++n2;
        }
        JOptionPane.showMessageDialog(this, b.toString(), "awkium", 1);
    }

    Properties getprop(Properties p) {
        String s = this.t3.getText();
        if (!this.c4.getSelectedItem().equals(DEF)) {
            if (this.c4.getSelectedItem().equals(CH1)) {
                if (s == null || s.equals("")) {
                    this.warnbox("1 character required");
                } else if (s.equals(" ")) {
                    p.setProperty("FS", "[ ]");
                } else if (s.length() > 1) {
                    this.warnbox("1 character required");
                } else {
                    p.setProperty("FS", s.substring(0, 1));
                }
            } else if (this.c4.getSelectedItem().equals(REG)) {
                p.setProperty("FS", s);
            }
        }
        return p;
    }

    void exec1() {
        LinkedList<File> fs = new LinkedList<File>();
        String s = this.t1.getText();
        Object sf = this.c3.getSelectedItem();
        if (s == null || s.equals("")) {
            this.warnbox("path required");
            return;
        }
        if (sf == null || sf.equals("")) {
            this.warnbox("file filter required");
            return;
        }
        WildcardFileFilter ff = new WildcardFileFilter(sf.toString());
        try {
            fs.add(new File(this.t1.getText()));
            while (!fs.isEmpty()) {
                File f = (File)fs.remove(0);
                if (!this.addfs(fs, f, this.c1.isSelected()) || !ff.accept(f)) continue;
                Awk.getInstance().overwrite(this.t2.getText(), f, (Writer)new NullWriter(), this.cs1.getSelectedCharset(), this.cs2.getSelectedCharset(), (Map<Object, Object>)this.getprop(new Properties()), new String[0]);
            }
            this.infobox("execute completed");
        }
        catch (IOException e) {
            this.errbox("I/O error:" + e.getMessage());
        }
        catch (AwkCompilationException e) {
            this.errbox("syntax error:" + e.getMessage());
        }
        catch (AwkRuntimeException e) {
            this.errbox("runtime error:" + e.getMessage());
        }
    }

    private void closeq(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void load1(File f) {
        block6: {
            StringWriter wr = new StringWriter();
            InputStreamReader rd = null;
            char[] a = new char[2048];
            try {
                try {
                    int l;
                    rd = new InputStreamReader(new FileInputStream(f));
                    while ((l = rd.read(a)) >= 0) {
                        wr.write(a, 0, l);
                    }
                    wr.flush();
                    this.t2.setText(wr.toString());
                }
                catch (IOException e) {
                    this.errbox("I/O error");
                    this.closeq(rd);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.closeq(rd);
                throw throwable;
            }
            this.closeq(rd);
        }
    }

    private void save1(File f) {
        block5: {
            OutputStreamWriter wr = null;
            try {
                try {
                    wr = new OutputStreamWriter(new FileOutputStream(f));
                    wr.write(this.t2.getText());
                    ((Writer)wr).flush();
                }
                catch (IOException e) {
                    this.errbox("I/O error");
                    this.closeq(wr);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeq(wr);
                throw throwable;
            }
            this.closeq(wr);
        }
    }

    AwkFrame() {
        super("awkium");
        GridBagConstraints ct = new GridBagConstraints();
        JPanel p1 = new JPanel();
        JPanel p2 = new JPanel();
        JPanel p3 = new JPanel();
        JPanel p4 = new JPanel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(600, 300));
        this.setSize(600, 450);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        p1.setLayout(new GridBagLayout());
        this.f1.setFileSelectionMode(2);
        ct.gridheight = 1;
        ct.gridwidth = 1;
        ct.weighty = 1.0;
        ct.weightx = 1.0;
        ct.fill = 1;
        p1.add((Component)new JLabel("Path:"), ct);
        ct.weightx = 8.0;
        p1.add((Component)this.t1, ct);
        ct.weightx = 1.0;
        ct.gridwidth = 0;
        JButton b1 = new JButton("File");
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.f1.showDialog(AwkFrame.this, "open");
                File f = AwkFrame.this.f1.getSelectedFile();
                if (f != null) {
                    AwkFrame.this.t1.setText(f.toString());
                }
            }
        });
        p1.add((Component)b1, ct);
        ct.gridwidth = 1;
        p1.add((Component)new JLabel("Filter:"), ct);
        ct.gridwidth = 0;
        this.c3.addItem("*.txt");
        this.c3.setEditable(true);
        p1.add((Component)this.c3, ct);
        ct.gridwidth = 2;
        p2.add(this.c1);
        p1.add((Component)p2, ct);
        b1 = new JButton("immediate");
        ct.gridwidth = 0;
        b1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.immediate.setVisible(true);
            }
        });
        p1.add((Component)b1, ct);
        ct.gridwidth = 0;
        this.c4.addItem(DEF);
        this.c4.addItem(CH1);
        this.c4.addItem(REG);
        this.c4.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AwkFrame.this.t3.setEnabled(!e.getItem().equals(AwkFrame.DEF));
            }
        });
        p4.add(new JLabel("Field Separator"));
        p4.add(this.c4);
        this.t3.setEnabled(false);
        p4.add(this.t3);
        p1.add((Component)p4, ct);
        ct.gridwidth = 0;
        p3.setLayout(new GridLayout(2, 2));
        p3.add(new JLabel("Input Encoding"));
        p3.add(new JLabel("Output Encoding"));
        p3.add(this.cs1);
        p3.add(this.cs2);
        p1.add((Component)p3, ct);
        cp.add((Component)p1, "North");
        cp.add((Component)new JScrollPane(this.t2), "Center");
        JButton b2 = new JButton("execute");
        b2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.exec1();
            }
        });
        cp.add((Component)b2, "South");
        JMenu m1 = new JMenu("File");
        JMenuItem i1 = new JMenuItem("Open File...");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.f2.showOpenDialog(AwkFrame.this);
                File f = AwkFrame.this.f2.getSelectedFile();
                if (f != null) {
                    File file = f;
                    AwkFrame.this.script = file;
                    AwkFrame.this.load1(file);
                }
            }
        });
        i1.setMnemonic('o');
        i1.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        m1.add(i1);
        i1 = new JMenuItem("Save");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.save1(AwkFrame.this.script);
            }
        });
        i1.setMnemonic('s');
        i1.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        m1.add(i1);
        i1 = new JMenuItem("Save As...");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.f3.showOpenDialog(AwkFrame.this);
                File f = AwkFrame.this.f3.getSelectedFile();
                if (f != null) {
                    File file = f;
                    AwkFrame.this.script = file;
                    AwkFrame.this.save1(file);
                }
            }
        });
        i1.setMnemonic('a');
        m1.add(i1);
        this.mb.add(m1);
        m1 = new JMenu("Help");
        i1 = new JMenuItem("Show Immediate Window");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.immediate.setVisible(true);
            }
        });
        m1.add(i1);
        i1 = new JMenuItem("About awkium");
        i1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AwkFrame.this.infobox("awkium Version 0.0.0", "Copyright 2013 Yuichiro Moriguchi", "This software under Apache 2.0 License");
            }
        });
        m1.add(i1);
        this.mb.add(m1);
        this.setJMenuBar(this.mb);
    }

    static boolean isHeadless() {
        return "true".equals(System.getProperty("java.awt.headless"));
    }

    static void repl() {
        System.err.println("awkium Ver. 0.0");
        Awk.getInstance().repl();
        System.exit(0);
    }

    public static void main(String[] args) {
        String[] a2 = new String[args.length + 1];
        int c = 0;
        try {
            if (args.length == 1 && args[0].equals("--repl")) {
                AwkFrame.repl();
            } else if (args.length > 0) {
                System.arraycopy(args, 0, a2, 1, args.length);
                a2[0] = "awkium";
                c = Awk.getInstance().invoke(new InputStreamReader(System.in), new OutputStreamWriter(System.out), new OutputStreamWriter(System.err), a2);
                System.exit(c);
            } else if (AwkFrame.isHeadless()) {
                AwkFrame.repl();
            } else {
                try {
                    new AwkFrame().setVisible(true);
                }
                catch (HeadlessException e) {
                    AwkFrame.repl();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(4);
        }
    }

    class AwkImmediate
    extends JDialog {
        JTextArea left;
        JTextArea right;

        AwkImmediate() {
            super((Frame)AwkFrame.this, "awkium - immediate");
            this.left = new JTextArea();
            this.right = new JTextArea();
            Container cp = this.getContentPane();
            JSplitPane s1 = new JSplitPane(1);
            this.setDefaultCloseOperation(1);
            this.setSize(500, 400);
            this.right.setEditable(false);
            s1.setLeftComponent(new JScrollPane(this.left));
            s1.setRightComponent(new JScrollPane(this.right));
            s1.setResizeWeight(0.5);
            JButton b1 = new JButton("execute");
            b1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    StringReader s = new StringReader(AwkFrame.this.t2.getText());
                    StringReader r = new StringReader(AwkImmediate.this.left.getText());
                    StringWriter w = new StringWriter();
                    try {
                        Awk.getInstance().execute((Reader)s, "<immediate>", r, (Writer)w, (Writer)new NullWriter(), AwkFrame.this.getprop(new Properties()), new String[0]);
                        AwkImmediate.this.right.setText(w.toString());
                    }
                    catch (IOException e) {
                        AwkFrame.this.errbox("I/O error:" + e.getMessage());
                    }
                    catch (AwkCompilationException e) {
                        AwkFrame.this.errbox("syntax error:" + e.getMessage());
                    }
                    catch (AwkRuntimeException e) {
                        AwkFrame.this.errbox("runtime error:" + e.getMessage());
                    }
                }
            });
            cp.setLayout(new BorderLayout());
            cp.add((Component)s1, "Center");
            cp.add((Component)b1, "South");
        }
    }
}

