/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat;

import java.math.BigInteger;
import java.util.Arrays;
import net.morilib.awk.stat.dist.continuous.GammaDistribution;

public final class StatisticsUtils {
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private StatisticsUtils() {
    }

    public static double sum(double ... vals) {
        double r = 0.0;
        int i = 0;
        while (i < vals.length) {
            r += vals[i];
            ++i;
        }
        return r;
    }

    public static long sum(int ... vals) {
        long r = 0L;
        int i = 0;
        while (i < vals.length) {
            r += (long)vals[i];
            ++i;
        }
        return r;
    }

    public static double mean(double ... vals) {
        return StatisticsUtils.sum(vals) / (double)vals.length;
    }

    public static double geometricMean(double ... vals) {
        double r = 0.0;
        int i = 0;
        while (i < vals.length) {
            r += Math.log(vals[i]);
            ++i;
        }
        return Math.exp(r / (double)vals.length);
    }

    public static double harmonicMean(double ... vals) {
        double r = 0.0;
        int i = 0;
        while (i < vals.length) {
            r += 1.0 / vals[i];
            ++i;
        }
        return (double)vals.length / r;
    }

    public static double median(double ... vals) {
        double[] ta = new double[vals.length];
        System.arraycopy(vals, 0, ta, 0, vals.length);
        Arrays.sort(ta);
        if (vals.length % 2 == 0) {
            return (ta[vals.length / 2 - 1] + ta[vals.length / 2]) / 2.0;
        }
        return ta[vals.length / 2];
    }

    public static BigInteger median(BigInteger ... vals) {
        Object[] ta = new BigInteger[vals.length];
        System.arraycopy(vals, 0, ta, 0, vals.length);
        Arrays.sort(ta);
        if (vals.length % 2 == 0) {
            return ((BigInteger)ta[vals.length / 2 - 1]).add((BigInteger)ta[vals.length / 2]).divide(TWO);
        }
        return ta[vals.length / 2];
    }

    public static double percentile(double percent, double ... vals) {
        double[] ta = new double[vals.length];
        System.arraycopy(vals, 0, ta, 0, vals.length);
        Arrays.sort(ta);
        double p = percent / 100.0 * (double)(vals.length - 1);
        int i = (int)p;
        double q = p - (double)i;
        if (percent < 0.0 || percent > 100.0) {
            throw new IllegalArgumentException();
        }
        if (percent == 0.0) {
            return ta[0];
        }
        if (percent == 100.0) {
            return ta[ta.length - 1];
        }
        return ta[i] * (1.0 - q) + ta[i + 1] * q;
    }

    public static double max(double ... vals) {
        double r = Double.MIN_VALUE;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] > r) {
                r = vals[i];
            }
            ++i;
        }
        return r;
    }

    public static int max(int ... vals) {
        int r = Integer.MIN_VALUE;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] > r) {
                r = vals[i];
            }
            ++i;
        }
        return r;
    }

    public static int whereIsMax(int ... vals) {
        int r = Integer.MIN_VALUE;
        int v = -1;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] > r) {
                r = vals[i];
                v = i;
            }
            ++i;
        }
        return v;
    }

    public static double min(double ... vals) {
        double r = Double.MAX_VALUE;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] < r) {
                r = vals[i];
            }
            ++i;
        }
        return r;
    }

    public static int min(int ... vals) {
        int r = Integer.MAX_VALUE;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] < r) {
                r = vals[i];
            }
            ++i;
        }
        return r;
    }

    public static double mode(double ... vals) {
        double max = StatisticsUtils.max(vals);
        double min = StatisticsUtils.min(vals);
        int[] hist = StatisticsUtils.toHistogram(vals);
        return StatisticsUtils.mode(min, max, hist);
    }

    public static BigInteger mode(BigInteger ... vals) {
        Object p;
        Object[] ta = new BigInteger[vals.length];
        Object m = p = null;
        int r = 0;
        int c = 0;
        System.arraycopy(vals, 0, ta, 0, vals.length);
        Arrays.sort(ta);
        int i = 0;
        while (i < vals.length) {
            Object v = ta[i];
            if (p == null || p != v) {
                p = v;
                if (c > r) {
                    r = c;
                    m = p;
                }
                c = 1;
            } else {
                ++c;
            }
            ++i;
        }
        return m;
    }

    public static int[] toHistogram(double ... vals) {
        int k = (int)Math.sqrt(vals.length);
        int[] r = new int[k + 2];
        double max = StatisticsUtils.max(vals);
        double min = StatisticsUtils.min(vals);
        if (vals.length == 0) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(r, 0);
        double h = (max - min) / (double)k;
        int i = 0;
        while (i < vals.length) {
            if (vals[i] == max) {
                int n = k;
                r[n] = r[n] + 1;
            } else if (vals[i] > max) {
                int n = k + 1;
                r[n] = r[n] + 1;
            } else if (vals[i] < min) {
                r[0] = r[0] + 1;
            } else {
                int n = (int)((vals[i] - min) / h) + 1;
                r[n] = r[n] + 1;
            }
            ++i;
        }
        return r;
    }

    public static double mode(double min, double max, int ... histogram) {
        int p = StatisticsUtils.whereIsMax(histogram);
        double q = ((double)p - 0.5) / (double)(histogram.length - 2);
        if (histogram.length < 2) {
            throw new IllegalArgumentException();
        }
        if (p == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == histogram.length) {
            return Double.POSITIVE_INFINITY;
        }
        return (max - min) * q + min;
    }

    public static double variance(double ... vals) {
        double r = 0.0;
        double m = StatisticsUtils.mean(vals);
        int i = 0;
        while (i < vals.length) {
            r += (vals[i] - m) * (vals[i] - m);
            ++i;
        }
        return r / (double)vals.length;
    }

    public static double unbiasedVariance(double ... vals) {
        double r = 0.0;
        double m = StatisticsUtils.mean(vals);
        int i = 0;
        while (i < vals.length) {
            r += (vals[i] - m) * (vals[i] - m);
            ++i;
        }
        return r / (double)(vals.length - 1);
    }

    public static double skewness(double ... vals) {
        double r = 0.0;
        double m = StatisticsUtils.mean(vals);
        double s = Math.sqrt(StatisticsUtils.variance(vals));
        int i = 0;
        while (i < vals.length) {
            double x = (vals[i] - m) / s;
            r += x * x * x;
            ++i;
        }
        return r / (double)vals.length;
    }

    public static double kurtosis(double ... vals) {
        double r = 0.0;
        double m = StatisticsUtils.mean(vals);
        double s = StatisticsUtils.variance(vals);
        int i = 0;
        while (i < vals.length) {
            r += (vals[i] - m) * (vals[i] - m) * (vals[i] - m) * (vals[i] - m);
            ++i;
        }
        return r / (double)vals.length / s / s - 3.0;
    }

    public static double covariance(double[] x, double[] y) {
        double r = 0.0;
        double mx = StatisticsUtils.mean(x);
        double my = StatisticsUtils.mean(y);
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        if (x.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < x.length) {
            r += (x[i] - mx) * (y[i] - my);
            ++i;
        }
        return r / (double)x.length;
    }

    public static double correlation(double[] x, double[] y) {
        double r = 0.0;
        double xs = 0.0;
        double ys = 0.0;
        double mx = StatisticsUtils.mean(x);
        double my = StatisticsUtils.mean(y);
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        if (x.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < x.length) {
            r += (x[i] - mx) * (y[i] - my);
            xs += (x[i] - mx) * (x[i] - mx);
            ys += (y[i] - my) * (y[i] - my);
            ++i;
        }
        return r / Math.sqrt(xs) / Math.sqrt(ys);
    }

    public static double[] regression(double[] x, double[] y) {
        double x11 = 0.0;
        double x12 = 0.0;
        double x21 = 0.0;
        double x22 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (x == null || y == null) {
            throw new NullPointerException();
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        if (x.length == 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < x.length) {
            x11 += 1.0;
            x12 += x[i];
            x21 += x[i];
            x22 += x[i] * x[i];
            y1 += y[i];
            y2 += x[i] * y[i];
            ++i;
        }
        double det = x11 * x22 - x12 * x21;
        double bt0 = (x11 * y2 - x21 * y1) / det;
        double bt1 = (y1 * x22 - y2 * x12) / det;
        return new double[]{bt0, bt1};
    }

    public static boolean testChiSquared(double[] obs, double[] exp, double alpha) {
        double chi = 0.0;
        int i = 0;
        while (i < obs.length && i < exp.length) {
            double x = obs[i] - exp[i];
            chi += x * x / exp[i];
            ++i;
        }
        GammaDistribution dis = GammaDistribution.chiSquared(i - 1);
        return chi < dis.invCdf(1.0 - alpha);
    }
}

