/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.t;

import java.util.Calendar;
import java.util.GregorianCalendar;

import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkValue;

public class TToarray extends AwkUnaryArgs {

	private static final AwkString AD = AwkString.valueOf("AD");
	private static final AwkString BC = AwkString.valueOf("BC");

	protected TToarray() {
		super("era");
	}

	private AwkInteger get(GregorianCalendar c, int a, int b) {
		return AwkInteger.valueOf(c.get(a) + b);
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		GregorianCalendar c = new GregorianCalendar();
		AwkArray a = new AwkArray();

		c.setTimeInMillis(a1.toInteger().longValue());
		switch(c.get(Calendar.ERA)) {
		case 0:   a.putArray("era", BC);  break;
		case 1:   a.putArray("era", AD);  break;
		default:  throw new RuntimeException();
		}
		a.putArray("year",      get(c, Calendar.YEAR, 0));
		a.putArray("month",     get(c, Calendar.MONTH, 1));
		a.putArray("day",       get(c, Calendar.DAY_OF_MONTH, 0));
		a.putArray("week",      get(c, Calendar.DAY_OF_WEEK, 0));
		a.putArray("dayofyear", get(c, Calendar.DAY_OF_YEAR, 0));
		a.putArray("hour",      get(c, Calendar.HOUR_OF_DAY, 0));
		a.putArray("min",       get(c, Calendar.MINUTE, 0));
		a.putArray("sec",       get(c, Calendar.SECOND, 0));
		a.putArray("millisec",  get(c, Calendar.MILLISECOND, 0));
		a.putArray("zone",      AwkInteger.valueOf(
				c.get(Calendar.ZONE_OFFSET) / 60 / 60 / 1000));
		return a;
	}

}
